/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.logger;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import de.gerdiproject.harvest.utils.file.FileUtils;
import de.gerdiproject.harvest.utils.logger.constants.LoggerConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvesterLog {
    private static Logger LOGGER = LoggerFactory.getLogger(HarvesterLog.class);
    private final FileAppender<ILoggingEvent> fileAppender;
    private final Charset charset;

    public HarvesterLog(String logFilePath) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        encoder.setPattern("%date %logger{0} %level %msg%n");
        encoder.start();
        this.fileAppender = new FileAppender();
        this.fileAppender.setContext((Context)loggerContext);
        this.fileAppender.setFile(logFilePath);
        this.fileAppender.setEncoder((Encoder)encoder);
        this.charset = StandardCharsets.UTF_8;
    }

    public void clearLog() {
        boolean wasStarted = this.fileAppender.isStarted();
        this.fileAppender.stop();
        FileUtils.deleteFile((File)new File(this.fileAppender.getFile()));
        if (wasStarted) {
            this.fileAppender.start();
        }
    }

    public void registerLogger() {
        if (!this.fileAppender.isStarted()) {
            this.fileAppender.start();
            LoggerConstants.ROOT_LOGGER.addAppender((Appender)this.fileAppender);
        }
    }

    public void unregisterLogger() {
        if (this.fileAppender.isStarted()) {
            this.fileAppender.stop();
            LoggerConstants.ROOT_LOGGER.detachAppender((Appender)this.fileAppender);
        }
    }

    public String getLog(List<String> dateFilters, List<String> levelFilters, List<String> classFilters) {
        StringBuilder logBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileAppender.getFile()), this.charset));){
            if (dateFilters == null && levelFilters == null && classFilters == null) {
                logBuilder.append(reader.lines().collect(Collectors.joining("\n")));
            } else {
                String line;
                boolean shouldAddLine = false;
                while ((line = reader.readLine()) != null) {
                    Matcher lineMatch = LoggerConstants.PARSE_LOG_PATTERN.matcher(line);
                    if (lineMatch.matches()) {
                        boolean bl = shouldAddLine = !(dateFilters != null && !dateFilters.contains(lineMatch.group(1)) || classFilters != null && !classFilters.contains(lineMatch.group(2)) || levelFilters != null && !levelFilters.contains(lineMatch.group(3)));
                    }
                    if (!shouldAddLine) continue;
                    logBuilder.append(line).append('\n');
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not read log file: %s", this.fileAppender.getFile()), (Throwable)e);
            return null;
        }
        return logBuilder.toString();
    }
}

