/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.data;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.IntegerParameter;
import de.gerdiproject.harvest.utils.data.IDataRetriever;
import de.gerdiproject.harvest.utils.data.constants.DataOperationConstants;
import de.gerdiproject.harvest.utils.data.enums.RestRequestType;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.ws.http.HTTPException;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDataRetriever
implements IDataRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDataRetriever.class);
    private final Gson gson;
    private final IntegerParameter retriesParam;
    private int timeout;
    private Charset charset;

    public WebDataRetriever(Gson gson, Charset charset, int timeout) {
        IntegerParameter retriesTemp;
        this.gson = gson;
        this.charset = charset;
        this.timeout = timeout;
        try {
            retriesTemp = (IntegerParameter)Configuration.registerParameter((AbstractParameter)DataOperationConstants.RETRIES_PARAM);
        }
        catch (IllegalStateException e) {
            retriesTemp = DataOperationConstants.RETRIES_PARAM;
        }
        this.retriesParam = retriesTemp;
    }

    public WebDataRetriever(Gson gson, Charset charset) {
        this(gson, charset, -1);
    }

    public WebDataRetriever(WebDataRetriever other) {
        this(other.gson, other.charset, other.timeout);
    }

    public String getString(String url) {
        String responseText = null;
        try (BufferedReader reader = new BufferedReader(this.createWebReader(url));){
            String line = reader.readLine();
            if (line != null) {
                StringBuilder responseBuilder = new StringBuilder(line);
                line = reader.readLine();
                while (line != null) {
                    responseBuilder.append('\n').append(line);
                    line = reader.readLine();
                }
                responseText = responseBuilder.toString();
            }
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Could not load and parse from web: %s", url), (Throwable)e);
        }
        return responseText;
    }

    public <T> T getObject(String url, Class<T> targetClass) {
        Object object = null;
        try (InputStreamReader reader = this.createWebReader(url);){
            object = this.gson.fromJson((Reader)reader, targetClass);
        }
        catch (JsonIOException | JsonSyntaxException | IOException | IllegalStateException e) {
            LOGGER.warn(String.format("Could not load and parse from web: %s", url), e);
        }
        return (T)object;
    }

    public <T> T getObject(String url, Type targetType) {
        Object object = null;
        try (InputStreamReader reader = this.createWebReader(url);){
            object = this.gson.fromJson((Reader)reader, targetType);
        }
        catch (JsonIOException | JsonSyntaxException | IOException | IllegalStateException e) {
            LOGGER.warn(String.format("Could not load and parse from web: %s", url), e);
        }
        return (T)object;
    }

    public Document getHtml(String url) {
        try {
            HttpURLConnection connection = this.sendWebRequest(RestRequestType.GET, url, null, null, "text/plain", ((Integer)this.retriesParam.getValue()).intValue());
            return Jsoup.parse((InputStream)this.getInputStream(connection), (String)this.charset.displayName(), (String)url);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Could not load and parse from web: %s", url), (Throwable)e);
            return null;
        }
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getRestResponse(RestRequestType method, String url, String body, String authorization, String contentType) throws HTTPException, IOException {
        HttpURLConnection connection = this.sendWebRequest(method, url, body, authorization, contentType, ((Integer)this.retriesParam.getValue()).intValue());
        InputStream response = this.getInputStream(connection);
        BufferedReader reader = new BufferedReader(new InputStreamReader(response, this.charset));
        String line = reader.readLine();
        String responseText = null;
        if (line != null) {
            StringBuilder responseBuilder = new StringBuilder(line);
            line = reader.readLine();
            while (line != null) {
                responseBuilder.append('\n').append(line);
                line = reader.readLine();
            }
            responseText = responseBuilder.toString();
        }
        reader.close();
        return responseText;
    }

    public Map<String, List<String>> getRestHeader(RestRequestType method, String url, String body, String authorization, String contentType) throws HTTPException, IOException {
        Map<String, List<String>> headerFields = null;
        HttpURLConnection connection = this.sendWebRequest(method, url, body, authorization, contentType, ((Integer)this.retriesParam.getValue()).intValue());
        headerFields = connection.getHeaderFields();
        return headerFields;
    }

    public HttpURLConnection sendWebRequest(RestRequestType method, String urlString, String body, String authorization, String contentType, int retries) throws IOException, HTTPException {
        URL url = new URL(urlString);
        HttpURLConnection connection = this.createConnection(method, url, body, authorization, contentType);
        boolean mustRetry = false;
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode >= 300) {
                connection.disconnect();
                if (responseCode >= 500) {
                    mustRetry = retries != 0;
                } else if (responseCode < 400) {
                    connection.disconnect();
                    String redirectedUrl = connection.getHeaderField("Location");
                    if (!(redirectedUrl == null || url.getProtocol().equalsIgnoreCase("https") && redirectedUrl.startsWith("http"))) {
                        return this.sendWebRequest(method, redirectedUrl, body, authorization, contentType, retries);
                    }
                }
                if (!mustRetry) {
                    String errorMessage = String.format("%s-request for URL '%s' with body '%s' returned HTTP Status-Code %d.", method.toString(), urlString, body, responseCode);
                    throw new HttpStatusException(errorMessage, responseCode, urlString);
                }
            }
        }
        catch (SocketTimeoutException e) {
            if (retries != 0) {
                mustRetry = true;
            }
            throw e;
        }
        if (mustRetry) {
            int delayInSeconds = connection.getHeaderFieldInt("Retry-After", 1);
            LOGGER.debug(String.format("Could not reach %s! Retrying in %d s.", urlString, delayInSeconds));
            try {
                Thread.sleep(delayInSeconds * 1000);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            return this.sendWebRequest(method, urlString, body, authorization, contentType, Math.max(retries - 1, -1));
        }
        return connection;
    }

    private HttpURLConnection createConnection(RestRequestType method, URL url, String body, String authorization, String contentType) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(true);
        connection.setUseCaches(false);
        connection.setRequestMethod(method.toString());
        connection.setRequestProperty("Content-Type", contentType);
        connection.setRequestProperty("charset", this.charset.displayName());
        connection.setRequestProperty("Accept-Encoding", "gzip");
        if (this.timeout != -1) {
            connection.setConnectTimeout(this.timeout);
            connection.setReadTimeout(this.timeout);
        }
        if (authorization != null) {
            connection.setRequestProperty("Authorization", authorization);
        }
        if (body != null) {
            byte[] bodyBytes = body.getBytes(this.charset);
            connection.setRequestProperty("Content-Length", Integer.toString(bodyBytes.length));
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.write(bodyBytes);
            wr.close();
        }
        return connection;
    }

    private InputStream getInputStream(HttpURLConnection connection) throws IOException {
        if ("gzip".equals(connection.getContentEncoding())) {
            return new GZIPInputStream(connection.getInputStream());
        }
        return connection.getInputStream();
    }

    private InputStreamReader createWebReader(String url) throws MalformedURLException, IOException {
        HttpURLConnection connection = this.sendWebRequest(RestRequestType.GET, url, null, null, "text/plain", ((Integer)this.retriesParam.getValue()).intValue());
        return new InputStreamReader(this.getInputStream(connection), this.charset);
    }
}

