/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * Exception performing whole class analysis ignored.
 */
public class HtmlUtils {
    public static String getString(Element element, String tagName) {
        Element stringElement = element.selectFirst(tagName);
        return stringElement == null ? null : stringElement.text();
    }

    public static List<String> getStringsFromParent(Element element, String parentTagName) {
        Element parent = element.selectFirst(parentTagName);
        return parent == null ? null : HtmlUtils.elementsToStringList((Collection)parent.children());
    }

    public static List<String> getStrings(Element element, String tagName) {
        return HtmlUtils.elementsToStringList((Collection)element.select(tagName));
    }

    public static <T> T getObject(Element element, String tagName, Function<Element, T> eleToObject) {
        Element requestedTag = element.selectFirst(tagName);
        return requestedTag == null ? null : (T)eleToObject.apply(requestedTag);
    }

    public static <T> List<T> getObjects(Element element, String tagName, Function<Element, T> eleToObject) {
        Elements eles = element.select(tagName);
        return eles == null ? null : HtmlUtils.elementsToList((Collection)eles, eleToObject);
    }

    public static <T> List<T> getObjectsFromParent(Element element, String parentTagName, Function<Element, T> eleToObject) {
        Element parent = element.selectFirst(parentTagName);
        return parent == null ? null : HtmlUtils.elementsToList((Collection)parent.children(), eleToObject);
    }

    public static String getAttribute(Element element, String attributeKey) {
        String attr = element.attr(attributeKey);
        return attr.isEmpty() ? null : attr;
    }

    public static <T extends Enum<T>> T getEnumAttribute(Element element, String attributeKey, Class<T> enumClass) {
        T returnValue = null;
        try {
            if (element.hasAttr(attributeKey)) {
                returnValue = Enum.valueOf(enumClass, element.attr(attributeKey).trim());
            }
        }
        catch (IllegalArgumentException e) {
            returnValue = null;
        }
        return returnValue;
    }

    public static <T> List<T> elementsToList(Collection<Element> elements, Function<Element, T> eleToObject) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        LinkedList<T> list = new LinkedList<T>();
        for (Element ele : elements) {
            T obj = eleToObject.apply(ele);
            if (obj == null) continue;
            list.add(obj);
        }
        return list.isEmpty() ? null : list;
    }

    public static List<String> elementsToStringList(Collection<Element> elements) {
        return HtmlUtils.elementsToList(elements, (T ele) -> ele.text());
    }

    private HtmlUtils() {
    }
}

