/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashGenerator {
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private MessageDigest messageDigest;
    private Charset charset;

    public HashGenerator(Charset charset) {
        MessageDigest temp;
        try {
            temp = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            temp = null;
        }
        this.charset = charset;
        this.messageDigest = temp;
    }

    public void reset() {
        this.charset = null;
        this.messageDigest = null;
    }

    public String getShaHash(String input) {
        byte[] digest = this.messageDigest.digest(input.getBytes(this.charset));
        char[] hexChars = new char[digest.length * 2];
        for (int i = 0; i < digest.length; ++i) {
            int b = 0xFF & digest[i];
            hexChars[i * 2] = HEX_ARRAY[b >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[b & 0xF];
        }
        return new String(hexChars);
    }
}

