/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.scheduler.utils;

import de.gerdiproject.harvest.scheduler.constants.CronConstants;
import de.gerdiproject.harvest.scheduler.utils.CronParser;
import java.util.Calendar;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class CronUtils {
    public static Date getNextMatchingDate(String cronTab) throws IllegalArgumentException {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(12, cal.get(12) + 1);
        return CronUtils.getNextMatchingDate((String)cronTab, (Date)cal.getTime());
    }

    public static Date getNextMatchingDate(String cronTab, Date earliestPossibleDate) throws IllegalArgumentException {
        int nextYear;
        String[] cronFields = cronTab.split(" ");
        if (cronFields.length != 5) {
            throw new IllegalArgumentException(String.format("Invalid cron tab '%s': A cron tab must consist of exactly five space-separated values!", cronTab));
        }
        byte[] minutes = CronParser.parseMinutes((String)cronFields[0]);
        byte[] hours = CronParser.parseHours((String)cronFields[1]);
        byte[] monthDays = CronParser.parseMonthDays((String)cronFields[2]);
        byte[] weekDays = CronParser.parseWeekDays((String)cronFields[4]);
        byte[] months = CronParser.parseMonths((String)cronFields[3], (byte[])monthDays, (byte[])weekDays);
        boolean isMonthDayRestricted = monthDays[0] != 1 || monthDays[monthDays.length - 1] != 31;
        boolean isWeekDayRestricted = weekDays[0] != 0 || weekDays[weekDays.length - 1] != 6;
        Calendar cal = Calendar.getInstance();
        cal.setTime(earliestPossibleDate);
        int currYear = cal.get(1);
        byte currMonth = (byte)(cal.get(2) + 1);
        byte currMonthDay = (byte)cal.get(5);
        byte currHour = (byte)cal.get(11);
        byte currMinute = (byte)cal.get(12);
        byte nextMinute = CronUtils.getNextMatch((byte[])minutes, (byte)currMinute);
        boolean isOverflowing = nextMinute < currMinute;
        byte nextHour = CronUtils.getNextMatch((byte[])hours, (byte)(isOverflowing ? (byte)(currHour + 1) : currHour));
        if (nextHour != currHour) {
            nextMinute = minutes[0];
        }
        isOverflowing = nextHour < currHour || nextHour == currHour && isOverflowing;
        byte nextDay = CronUtils.calculateNextDay((byte[])monthDays, (byte[])weekDays, (Calendar)cal, (boolean)isOverflowing);
        isOverflowing = nextDay < currMonthDay || nextDay == currMonthDay && isOverflowing;
        byte nextMonth = CronUtils.getNextMatch((byte[])months, (byte)(isOverflowing ? (byte)(currMonth + 1) : currMonth));
        isOverflowing = nextMonth < currMonth || nextMonth == currMonth && isOverflowing;
        int n = nextYear = isOverflowing ? currYear + 1 : currYear;
        if (!isWeekDayRestricted) {
            while (CronUtils.getDaysInMonth((byte)nextMonth, (int)nextYear) < nextDay) {
                byte prevMonth = nextMonth;
                nextMonth = (byte)(nextMonth + 1);
                if ((nextMonth = CronUtils.getNextMatch((byte[])months, (byte)nextMonth)) > prevMonth) continue;
                ++nextYear;
            }
        }
        if (nextMonth != currMonth || nextYear != currYear) {
            nextMinute = minutes[0];
            nextHour = hours[0];
            if (isWeekDayRestricted) {
                cal.clear();
                cal.set(1, nextYear);
                cal.set(2, nextMonth - 1);
                byte firstDayInMonth = (byte)(cal.get(7) - 1);
                byte nextWeekDay = CronUtils.getNextMatch((byte[])weekDays, (byte)firstDayInMonth);
                nextDay = (byte)(firstDayInMonth <= nextWeekDay ? 1 + nextWeekDay - firstDayInMonth : 8 + nextWeekDay - firstDayInMonth);
            }
            if (!isWeekDayRestricted || isMonthDayRestricted && monthDays[0] < nextDay) {
                nextDay = monthDays[0];
            }
        }
        cal.set(nextYear, nextMonth - 1, nextDay, nextHour, nextMinute, 0);
        return cal.getTime();
    }

    public static int getDaysInMonth(byte month, int year) {
        int days = ((Byte)CronConstants.MAX_DAYS_IN_MONTH_MAP.get(month)).byteValue();
        if (month == 2 && year % 4 == 0 && (year % 100 != 0 || year % 400 == 0)) {
            ++days;
        }
        return days;
    }

    private static byte calculateNextDay(byte[] monthDays, byte[] weekDays, Calendar cal, boolean isOverflowing) {
        int currYear = cal.get(1);
        byte currMonth = (byte)(cal.get(2) + 1);
        byte currMonthDay = (byte)cal.get(5);
        byte currWeekDay = (byte)(cal.get(7) - 1);
        boolean isMonthDayRestricted = monthDays[0] != 1 || monthDays[monthDays.length - 1] != 31;
        boolean isWeekDayRestricted = weekDays[0] != 0 || weekDays[weekDays.length - 1] != 6;
        int daysInThisMonth = CronUtils.getDaysInMonth((byte)currMonth, (int)currYear);
        byte nextMonthDay = CronUtils.getNextMatch((byte[])monthDays, (byte)(isOverflowing ? (byte)(currMonthDay + 1) : currMonthDay));
        if (nextMonthDay > currMonthDay && daysInThisMonth < nextMonthDay) {
            nextMonthDay = monthDays[0];
        }
        byte nextDay = nextMonthDay;
        if (isWeekDayRestricted) {
            boolean isWeekDayWrapped;
            byte nextWeekDay = CronUtils.getNextMatch((byte[])weekDays, (byte)currWeekDay);
            int daysUntilNextWeekDay = nextWeekDay > currWeekDay || nextWeekDay == currWeekDay && !isOverflowing ? nextWeekDay - currWeekDay : nextWeekDay + 1 + 6 - currWeekDay;
            byte nextMonthDay2 = (byte)(currMonthDay + daysUntilNextWeekDay);
            if (nextMonthDay2 > currMonthDay && daysInThisMonth < nextMonthDay2) {
                nextMonthDay2 = (byte)(nextMonthDay2 - daysInThisMonth);
            }
            boolean isMonthDayWrapped = nextMonthDay < currMonthDay || nextMonthDay > daysInThisMonth;
            boolean bl = isWeekDayWrapped = nextMonthDay2 < currMonthDay;
            if (!isMonthDayRestricted || isMonthDayWrapped == isWeekDayWrapped && nextMonthDay2 < nextMonthDay || isMonthDayWrapped) {
                nextDay = nextMonthDay2;
            }
        }
        return nextDay;
    }

    private static byte getNextMatch(byte[] timeArray, byte minTime) {
        int i;
        int len = timeArray.length;
        for (i = 0; i < len && timeArray[i] < minTime; ++i) {
        }
        return timeArray[i % len];
    }

    private CronUtils() {
    }
}

