/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.scheduler.constants;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CronConstants {
    public static final int MINUTES_MIN_CRON = 0;
    public static final int MINUTES_MAX_CRON = 59;
    public static final int HOURS_MIN_CRON = 0;
    public static final int HOURS_MAX_CRON = 23;
    public static final int DAYS_MIN_CRON = 1;
    public static final int DAYS_MAX_CRON = 31;
    public static final int MONTHS_MIN_CRON = 1;
    public static final int MONTHS_MAX_CRON = 12;
    public static final int WEEK_DAYS_MIN_CRON = 0;
    public static final int WEEK_DAYS_MAX_CRON = 6;
    public static final String ERROR_NO_MONTHS = "Invalid cron month restriction '%s': The restriction of days and months causes this job to never be executed!";
    public static final String ERROR_CANNOT_PARSE = "Cannot parse cron field '%s'!";
    public static final String ERROR_OUT_OF_RANGE = "Cron field '%s' out of range [%d, %d]!";
    public static final String ERROR_PARSE_FREQUENCY = "Invalid frequency in cron field '%s'!";
    public static final String ERROR_PARSE_RANGE = "Invalid range in cron field '%s'!";
    public static final String ERROR_CRON_FORMAT = "Invalid cron tab '%s': A cron tab must consist of exactly five space-separated values!";
    public static final Map<Byte, Byte> MAX_DAYS_IN_MONTH_MAP = CronConstants.createDaysInMonthMap();

    private static Map<Byte, Byte> createDaysInMonthMap() {
        HashMap<Byte, Byte> map = new HashMap<Byte, Byte>();
        map.put((byte)1, (byte)31);
        map.put((byte)2, (byte)28);
        map.put((byte)3, (byte)31);
        map.put((byte)4, (byte)30);
        map.put((byte)5, (byte)31);
        map.put((byte)6, (byte)30);
        map.put((byte)7, (byte)31);
        map.put((byte)8, (byte)31);
        map.put((byte)9, (byte)30);
        map.put((byte)10, (byte)31);
        map.put((byte)11, (byte)30);
        map.put((byte)12, (byte)31);
        return Collections.unmodifiableMap(map);
    }

    private CronConstants() {
    }
}

