/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.scheduler;

import com.google.gson.Gson;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.rest.AbstractRestObject;
import de.gerdiproject.harvest.scheduler.HarvestingTimerTask;
import de.gerdiproject.harvest.scheduler.events.GetSchedulerEvent;
import de.gerdiproject.harvest.scheduler.events.ScheduledTaskExecutedEvent;
import de.gerdiproject.harvest.scheduler.json.ChangeSchedulerRequest;
import de.gerdiproject.harvest.scheduler.json.SchedulerResponse;
import de.gerdiproject.harvest.scheduler.utils.CronUtils;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.harvest.utils.file.ICachedObject;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler
extends AbstractRestObject<Scheduler, SchedulerResponse>
implements ICachedObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);
    private Timer timer;
    private final Map<String, TimerTask> registeredTasks;
    private final DiskIO diskIo;
    private final String cacheFilePath;
    private final Consumer<ScheduledTaskExecutedEvent> onTaskExecuted = event -> this.rescheduleTask(event.getExecutedTask());

    public Scheduler(String moduleName, String cacheFilePath) {
        super(moduleName, GetSchedulerEvent.class);
        this.timer = new Timer();
        this.registeredTasks = new ConcurrentHashMap();
        this.diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        this.cacheFilePath = cacheFilePath;
    }

    public void addEventListeners() {
        super.addEventListeners();
        EventSystem.addListener(ScheduledTaskExecutedEvent.class, (Consumer)this.onTaskExecuted);
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        EventSystem.removeListener(ScheduledTaskExecutedEvent.class, (Consumer)this.onTaskExecuted);
    }

    public void saveToDisk() {
        this.diskIo.writeObjectToFile(this.cacheFilePath, this.registeredTasks.keySet());
    }

    public void loadFromDisk() {
        String[] cachedCronTabs = (String[])this.diskIo.getObject(this.cacheFilePath, String[].class);
        if (cachedCronTabs != null) {
            this.registeredTasks.clear();
            for (String cronTab : cachedCronTabs) {
                try {
                    this.scheduleTask(cronTab);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(String.format("Cannot load cron tab from disk: %s", cronTab), (Throwable)e);
                }
            }
            LOGGER.info("Successfully loaded schedule from disk!");
        }
    }

    public int size() {
        return this.registeredTasks.size();
    }

    public Date getNextHarvestDate() {
        long nextTimestamp = Long.MAX_VALUE;
        for (TimerTask scheduledTask : this.registeredTasks.values()) {
            nextTimestamp = Math.min(nextTimestamp, scheduledTask.scheduledExecutionTime());
        }
        return nextTimestamp == Long.MAX_VALUE ? null : new Date(nextTimestamp);
    }

    private void scheduleTask(String cronTab) throws IllegalArgumentException, IllegalStateException {
        TimerTask oldTask = (TimerTask)this.registeredTasks.get(cronTab);
        if (oldTask != null) {
            oldTask.cancel();
        }
        Date nextDate = CronUtils.getNextMatchingDate((String)cronTab);
        HarvestingTimerTask harvestingTask = new HarvestingTimerTask();
        this.timer.schedule((TimerTask)harvestingTask, nextDate);
        this.registeredTasks.put(cronTab, harvestingTask);
        LOGGER.debug(String.format("Scheduled Task '%s' will be next executed at %s", cronTab, nextDate.toString()));
    }

    private void rescheduleTask(TimerTask rescheduledTask) {
        this.registeredTasks.forEach((cronTab, task) -> {
            if (task == rescheduledTask) {
                try {
                    this.scheduleTask(cronTab);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(String.format("Cannot re-schedule task: %s", cronTab), (Throwable)e);
                }
            }
        });
    }

    protected void destroy() {
        super.destroy();
        this.timer.cancel();
        this.timer.purge();
        this.registeredTasks.clear();
    }

    protected String getPrettyPlainText() {
        StringBuilder sb = new StringBuilder();
        if (this.registeredTasks.isEmpty()) {
            sb.append('-');
        } else {
            for (String cronTab : this.registeredTasks.keySet()) {
                if (sb.length() != 0) {
                    sb.append('\n');
                }
                sb.append(cronTab);
            }
        }
        sb.insert(0, "Scheduled Harvests:\n");
        return sb.toString();
    }

    public SchedulerResponse getAsJson(MultivaluedMap<String, String> query) {
        return new SchedulerResponse(this.registeredTasks.keySet());
    }

    public String addTask(ChangeSchedulerRequest addRequest) {
        String cronTab = addRequest.getCronTab();
        if (cronTab == null) {
            throw new IllegalArgumentException("Cannot perform schedule operation. You must specify a valid 'cronTab' as a JSON field!");
        }
        if (this.registeredTasks.containsKey(cronTab)) {
            throw new IllegalArgumentException(String.format("Cannot add task, because it already exists: %s", cronTab));
        }
        this.scheduleTask(cronTab);
        this.saveToDisk();
        return String.format("Successfully added task: %s", cronTab);
    }

    public String deleteTask(ChangeSchedulerRequest deleteRequest) throws IllegalArgumentException {
        String cronTab = deleteRequest.getCronTab();
        if (cronTab == null) {
            throw new IllegalArgumentException("Cannot perform schedule operation. You must specify a valid 'cronTab' as a JSON field!");
        }
        if (!this.registeredTasks.containsKey(cronTab)) {
            throw new IllegalArgumentException(String.format("Cannot remove task, because it does not exist: %s!", cronTab));
        }
        TimerTask removedTask = (TimerTask)this.registeredTasks.remove(cronTab);
        removedTask.cancel();
        this.saveToDisk();
        return String.format("Removed task: %s", cronTab);
    }

    public String deleteAllTasks() {
        int oldNumberOfTasks = this.registeredTasks.size();
        this.timer.cancel();
        this.timer.purge();
        this.registeredTasks.clear();
        this.saveToDisk();
        this.timer = new Timer();
        return String.format("Deleted all %d scheduled tasks!", oldNumberOfTasks);
    }
}

