/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.scheduler;

import de.gerdiproject.harvest.etls.ETLPreconditionException;
import de.gerdiproject.harvest.etls.events.GetETLManagerEvent;
import de.gerdiproject.harvest.etls.utils.ETLManager;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEvent;
import de.gerdiproject.harvest.event.ISynchronousEvent;
import de.gerdiproject.harvest.scheduler.Scheduler;
import de.gerdiproject.harvest.scheduler.events.ScheduledTaskExecutedEvent;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvestingTimerTask
extends TimerTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);

    @Override
    public void run() {
        String status;
        ETLManager etlManager = (ETLManager)EventSystem.sendSynchronousEvent((ISynchronousEvent)new GetETLManagerEvent());
        try {
            etlManager.harvest();
            status = "Harvest started!";
        }
        catch (ETLPreconditionException e) {
            status = e.getMessage();
        }
        LOGGER.info(String.format("Scheduler attempts to start a harvest: %s", status));
        EventSystem.sendEvent((IEvent)new ScheduledTaskExecutedEvent((TimerTask)this));
    }
}

