/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.rest;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.ISynchronousEvent;
import de.gerdiproject.harvest.rest.AbstractRestObject;
import de.gerdiproject.harvest.rest.HttpResponseFactory;
import de.gerdiproject.harvest.rest.events.GetRestObjectEvent;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.function.Function;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public abstract class AbstractRestResource<T extends AbstractRestObject<T, ?>, S extends GetRestObjectEvent<T>> {
    protected final T restObject;
    protected final Gson gson;

    public AbstractRestResource(Gson gson) {
        AbstractRestObject retrievedObject;
        Class getEventClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        try {
            retrievedObject = (AbstractRestObject)EventSystem.sendSynchronousEvent((ISynchronousEvent)((ISynchronousEvent)getEventClass.newInstance()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            retrievedObject = null;
        }
        this.restObject = retrievedObject;
        this.gson = gson;
    }

    public AbstractRestResource() {
        this(new Gson());
    }

    @GET
    @Produces(value={"text/plain", "application/json"})
    public Response getInfoText(@Context UriInfo uriInfo) {
        if (this.restObject == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        boolean isPlainText = false;
        if (uriInfo.getQueryParameters().get((Object)"pretty") != null) {
            String prettyValue = (String)((List)uriInfo.getQueryParameters().get((Object)"pretty")).get(0);
            isPlainText = prettyValue.isEmpty() || prettyValue.equals(String.valueOf(true));
        }
        try {
            if (isPlainText) {
                String responseText = this.restObject.getAsPlainText();
                String allowedRequests = this.getAllowedRequests().replaceAll("(^|\n)(\\w)", "$1  $2");
                return HttpResponseFactory.createPlainTextOkResponse((String)(responseText + allowedRequests));
            }
            Object responseObject = this.restObject.getAsJson(uriInfo.getQueryParameters());
            if (responseObject == null) {
                return HttpResponseFactory.createServerErrorResponse();
            }
            return HttpResponseFactory.createOkResponse((Object)this.gson.toJsonTree(responseObject));
        }
        catch (IllegalArgumentException e) {
            return HttpResponseFactory.createBadRequestResponse((String)e.getMessage());
        }
        catch (Exception e) {
            return HttpResponseFactory.createKnownErrorResponse((String)e.getMessage());
        }
    }

    protected abstract String getAllowedRequests();

    protected <P, R> Response changeObject(Function<P, R> changeFunction, String jsonRaw, Class<P> jsonClass) {
        R response;
        Object jsonBody;
        if (this.restObject == null) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        if (jsonRaw == null || jsonRaw.isEmpty()) {
            return HttpResponseFactory.createBadRequestResponse((String)"You must specify a JSON body!");
        }
        try {
            jsonBody = this.gson.fromJson(jsonRaw, jsonClass);
        }
        catch (JsonSyntaxException | NullPointerException e) {
            jsonBody = null;
        }
        if (jsonBody == null) {
            return HttpResponseFactory.createBadRequestResponse((String)String.format("Invalid JSON object:%n%s", jsonRaw));
        }
        try {
            response = changeFunction.apply(jsonBody);
        }
        catch (IllegalArgumentException e) {
            return HttpResponseFactory.createBadRequestResponse((String)e.getMessage());
        }
        catch (IllegalStateException e) {
            return HttpResponseFactory.createServerErrorResponse();
        }
        return HttpResponseFactory.createOkResponse(response);
    }
}

