/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.rest;

import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEventListener;
import de.gerdiproject.harvest.rest.events.GetRestObjectEvent;
import java.util.function.Consumer;
import javax.ws.rs.core.MultivaluedMap;

public abstract class AbstractRestObject<T extends AbstractRestObject<T, P>, P>
implements IEventListener {
    private Class<? extends GetRestObjectEvent<T>> getterEventClass;
    protected final String moduleName;
    private final Consumer<ContextDestroyedEvent> onContextDestroyed = event -> this.destroy();

    public AbstractRestObject(String moduleName, Class<? extends GetRestObjectEvent<T>> getterEventClass) {
        this.moduleName = moduleName;
        this.getterEventClass = getterEventClass;
    }

    public void addEventListeners() {
        EventSystem.addSynchronousListener((Class)this.getterEventClass, () -> this);
        EventSystem.addListener(ContextDestroyedEvent.class, (Consumer)this.onContextDestroyed);
    }

    public void removeEventListeners() {
        EventSystem.removeSynchronousListener((Class)this.getterEventClass);
        EventSystem.removeListener(ContextDestroyedEvent.class, (Consumer)this.onContextDestroyed);
    }

    public final String getAsPlainText() {
        return String.format("- %s %s -%n%n%s%n%nAllowed Requests:%n", this.moduleName, this.getClass().getSimpleName(), this.getPrettyPlainText());
    }

    protected void destroy() {
        this.removeEventListeners();
    }

    protected abstract String getPrettyPlainText();

    public abstract P getAsJson(MultivaluedMap<String, String> var1);
}

