/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.utils;

import de.gerdiproject.harvest.etls.utils.TimestampedEntry;
import de.gerdiproject.harvest.etls.utils.TimestampedEntryComparator;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;

public class TimestampedList<T>
extends LinkedList<TimestampedEntry<T>> {
    private static final long serialVersionUID = 6315549009940523304L;
    private static final TimestampedEntryComparator COMPARATOR = new TimestampedEntryComparator();
    private final transient int capacity;

    public TimestampedList(int capacity) {
        this.capacity = capacity;
    }

    public TimestampedList(T initialValue, int capacity) {
        this(capacity);
        this.addValue(initialValue);
    }

    public void addValue(T value) {
        if (this.size() == this.capacity) {
            this.removeFirst();
        }
        this.add((Object)new TimestampedEntry(value));
    }

    public void addAllSorted(Collection<TimestampedEntry<T>> other) {
        if (other != null && !other.isEmpty()) {
            this.addAll(other);
            this.sort((Comparator)COMPARATOR);
            while (this.size() > this.capacity) {
                this.removeFirst();
            }
        }
    }

    public T getLatestValue() {
        return (T)((TimestampedEntry)this.getLast()).getValue();
    }

    public long getLatestTimestamp() {
        return ((TimestampedEntry)this.getLast()).getTimestamp();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TimestampedEntry entry : this) {
            if (sb.length() != 0) {
                sb.append('\n');
            }
            sb.append(entry.toString());
        }
        return sb.toString();
    }
}

