/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.utils;

import java.time.Instant;

public class TimestampedEntry<T> {
    private final T value;
    private final long timestamp;

    public TimestampedEntry(T value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
    }

    public TimestampedEntry(T value) {
        this(value, System.currentTimeMillis());
    }

    public T getValue() {
        return (T)this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.value.toString() + " since " + Instant.ofEpochMilli(this.timestamp);
    }
}

