/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.utils;

import com.google.gson.Gson;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.BooleanParameter;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.ETLPreconditionException;
import de.gerdiproject.harvest.etls.constants.ETLConstants;
import de.gerdiproject.harvest.etls.enums.ETLHealth;
import de.gerdiproject.harvest.etls.enums.ETLState;
import de.gerdiproject.harvest.etls.events.GetETLManagerEvent;
import de.gerdiproject.harvest.etls.events.GetRepositoryNameEvent;
import de.gerdiproject.harvest.etls.events.HarvestFinishedEvent;
import de.gerdiproject.harvest.etls.events.HarvestStartedEvent;
import de.gerdiproject.harvest.etls.json.ETLInfosJson;
import de.gerdiproject.harvest.etls.json.ETLJson;
import de.gerdiproject.harvest.etls.json.ETLManagerJson;
import de.gerdiproject.harvest.etls.utils.TimestampedEntry;
import de.gerdiproject.harvest.etls.utils.TimestampedList;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEvent;
import de.gerdiproject.harvest.event.ISynchronousEvent;
import de.gerdiproject.harvest.rest.AbstractRestObject;
import de.gerdiproject.harvest.scheduler.Scheduler;
import de.gerdiproject.harvest.scheduler.events.GetSchedulerEvent;
import de.gerdiproject.harvest.utils.HashGenerator;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.harvest.utils.file.ICachedObject;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ETLManager
extends AbstractRestObject<ETLManager, ETLManagerJson>
implements ICachedObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(ETLManager.class);
    private final DiskIO diskIo;
    private final File cacheFile;
    private final List<AbstractETL<?, ?>> etls;
    private final BooleanParameter concurrentParam;
    private final BooleanParameter forceHarvestParameter;
    private final TimestampedList<ETLState> combinedStateHistory = new TimestampedList((Object)ETLState.INITIALIZING, 10);
    private String lastHarvestHash;

    public ETLManager(String moduleName) {
        super(moduleName, GetETLManagerEvent.class);
        this.etls = new LinkedList();
        this.concurrentParam = (BooleanParameter)Configuration.registerParameter((AbstractParameter)ETLConstants.CONCURRENT_PARAM);
        this.forceHarvestParameter = (BooleanParameter)Configuration.registerParameter((AbstractParameter)ETLConstants.FORCED_PARAM);
        this.cacheFile = new File(String.format("cache/%s/state.json", moduleName));
        this.diskIo = new DiskIO(new Gson(), StandardCharsets.UTF_8);
        this.setStatus(ETLState.IDLE);
    }

    public void loadFromDisk() {
        ETLInfosJson loadedState = (ETLInfosJson)this.diskIo.getObject(this.cacheFile, ETLInfosJson.class);
        if (loadedState != null) {
            ETLJson overallInfo = loadedState.getOverallInfo();
            Map etlInfos = loadedState.getEtlInfos();
            if (overallInfo != null && etlInfos != null) {
                this.lastHarvestHash = overallInfo.getVersionHash();
                this.combinedStateHistory.addAllSorted((Collection)overallInfo.getStateHistory());
                for (AbstractETL etl : this.etls) {
                    String etlName = etl.getName();
                    ETLJson etlInfo = (ETLJson)etlInfos.get(etlName);
                    if (etlInfo != null) {
                        etl.loadFromJson(etlInfo);
                        continue;
                    }
                    LOGGER.warn(String.format("Could not load %s state from cache!", etlName));
                }
                LOGGER.debug(String.format(ETLConstants.ETL_MANAGER_LOADED, this.cacheFile));
            } else {
                LOGGER.warn(ETLConstants.ETL_MANAGER_LOAD_ERROR);
            }
        }
    }

    public void saveToDisk() {
        this.diskIo.writeObjectToFile(this.cacheFile, (Object)this.getETLsAsJson());
    }

    protected String getPrettyPlainText() {
        StringBuilder sb = new StringBuilder();
        int totalCurrCount = 0;
        int totalMaxCount = 0;
        for (AbstractETL etl : this.etls) {
            sb.append(etl.toString());
            if (!etl.isEnabled()) continue;
            totalCurrCount += etl.getHarvestedCount();
            int maxCount = etl.getMaxNumberOfDocuments();
            if (maxCount != -1 && totalMaxCount != -1) {
                totalMaxCount += maxCount;
                continue;
            }
            totalMaxCount = -1;
        }
        ETLState state = this.getState();
        String stateString = state.toString().toLowerCase();
        if (state == ETLState.HARVESTING) {
            stateString = totalMaxCount != -1 ? stateString + String.format(" % 3d%% (%d / %d)", Math.round(100.0f * (float)totalCurrCount / (float)totalMaxCount), totalCurrCount, totalMaxCount) : stateString + String.format(" (%d / ???)", totalCurrCount);
        }
        sb.append(String.format("%s : %s [Health: %s]%n", "---\nOVERALL", stateString, this.getHealth()));
        if (state == ETLState.HARVESTING) {
            long remainingMilliSeconds = this.estimateRemainingHarvestTime(totalCurrCount, totalMaxCount);
            sb.append(ETLManager.getDurationText((long)remainingMilliSeconds));
        }
        return sb.toString();
    }

    public ETLManagerJson getAsJson(MultivaluedMap<String, String> query) {
        String repositoryName = (String)EventSystem.sendSynchronousEvent((ISynchronousEvent)new GetRepositoryNameEvent());
        int harvestedCount = this.getHarvestedCount();
        int maxDocumentCount = this.getMaxNumberOfDocuments();
        long remainingHarvestTime = this.estimateRemainingHarvestTime(harvestedCount, maxDocumentCount);
        long lastHarvestTimestamp = this.getLatestHarvestTimestamp();
        Date nextHarvestDate = ((Scheduler)EventSystem.sendSynchronousEvent((ISynchronousEvent)new GetSchedulerEvent())).getNextHarvestDate();
        boolean hasEnabledETLs = false;
        for (AbstractETL etl : this.etls) {
            if (!etl.isEnabled()) continue;
            hasEnabledETLs = true;
            break;
        }
        return new ETLManagerJson(repositoryName, this.getState(), this.getHealth(), harvestedCount, maxDocumentCount != -1 ? Integer.valueOf(maxDocumentCount) : null, remainingHarvestTime != -1L ? Long.valueOf(remainingHarvestTime) : null, lastHarvestTimestamp != -1L ? new Date(lastHarvestTimestamp).toString() : null, nextHarvestDate != null ? nextHarvestDate.toString() : null, hasEnabledETLs);
    }

    public ETLInfosJson getETLsAsJson() {
        return new ETLInfosJson(new ETLJson(this.getClass().getSimpleName(), (List)this.combinedStateHistory, (List)new TimestampedList((Object)this.getHealth(), 1), this.getHarvestedCount(), this.getMaxNumberOfDocuments(), this.getHash()), this.etls);
    }

    public ETLJson getETLAsJson(MultivaluedMap<String, String> query) {
        List nameList;
        List list = nameList = query != null ? (List)query.get((Object)"name") : null;
        if (nameList == null || nameList.isEmpty()) {
            throw new IllegalArgumentException("Missing query parameter 'name'!");
        }
        String etlName = (String)nameList.get(0);
        Optional<AbstractETL> etl = this.etls.stream().filter(e -> e.getName().equalsIgnoreCase(etlName)).findFirst();
        if (!etl.isPresent()) {
            throw new IllegalArgumentException(String.format("Unknown ETL name '%s'!", etlName));
        }
        return etl.get().getAsJson();
    }

    public void register(AbstractETL<?, ?> addedEtl) {
        if (this.etls.contains(addedEtl)) {
            LOGGER.info(String.format("Did not register %s, because it was already registered!", addedEtl.getClass().getSimpleName()));
        } else {
            String etlNameOrig;
            String etlName = etlNameOrig = addedEtl.getName().replaceAll("[^a-zA-Z0-9]", "");
            int duplicateCount = 1;
            while (true) {
                String etlNameTemp = etlName;
                if (this.etls.stream().noneMatch(e -> e.getName().equals(etlNameTemp))) break;
                etlName = etlNameOrig + ++duplicateCount;
            }
            addedEtl.setName(etlName);
            this.etls.add(addedEtl);
        }
    }

    public boolean hasOutdatedETLs() {
        ETLState currentStatus = this.getState();
        if (currentStatus == ETLState.IDLE || currentStatus == ETLState.DONE) {
            this.processETLs(harvester -> harvester.update());
        }
        int maxDocs = this.getMaxNumberOfDocuments();
        int currentDocs = this.getHarvestedCount();
        if (maxDocs == -1 && currentDocs == 0 || currentDocs < maxDocs) {
            return true;
        }
        String currentHash = this.getHash();
        return currentHash == null || !currentHash.equals(this.lastHarvestHash);
    }

    public void addEventListeners() {
        super.addEventListeners();
        for (AbstractETL etl : this.etls) {
            etl.addEventListeners();
        }
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        for (AbstractETL etl : this.etls) {
            etl.removeEventListeners();
        }
    }

    public void harvest() throws IllegalStateException {
        if (this.getState() != ETLState.IDLE) {
            throw new IllegalStateException("Cannot start harvest: Please wait for the current harvest to finish, or abort it!");
        }
        if (!((Boolean)this.forceHarvestParameter.getValue()).booleanValue() && !this.hasOutdatedETLs()) {
            throw new ETLPreconditionException("Did not start harvest, because no changes were detected!");
        }
        ((CompletableFuture)CompletableFuture.runAsync(() -> {
            boolean isPrepared = this.prepareETLsForHarvest();
            if (!isPrepared) {
                throw new ETLPreconditionException("Cannot start harvest: No ETL could be prepared!");
            }
            this.harvestETLs();
        }).thenAccept(v -> {
            this.lastHarvestHash = this.getHash();
            this.saveToDisk();
            ETLState status = this.getState();
            if (status == ETLState.ABORTING) {
                LOGGER.info("All ETLs have been aborted!");
            } else if (status == ETLState.HARVESTING) {
                LOGGER.info("Harvest finished!");
            }
            EventSystem.sendEvent((IEvent)new HarvestFinishedEvent(true, this.lastHarvestHash));
            this.setStatus(ETLState.IDLE);
        })).exceptionally(reason -> {
            LOGGER.error("Harvesting interrupted by unexpected error!", reason);
            this.processETLs(harvester -> harvester.cancelHarvest());
            this.saveToDisk();
            LOGGER.info("Harvest failed!");
            EventSystem.sendEvent((IEvent)new HarvestFinishedEvent(false, this.getHash()));
            this.setStatus(ETLState.IDLE);
            return null;
        });
    }

    public int getMaxNumberOfDocuments() {
        List sizes = this.processETLs(harvester -> harvester.getMaxNumberOfDocuments());
        int total = 0;
        Iterator iterator = sizes.iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            if (size == -1) {
                return -1;
            }
            total += size;
        }
        return total;
    }

    public void abortHarvest() {
        ETLState currentStatus = this.getState();
        if (currentStatus != ETLState.QUEUED && currentStatus != ETLState.HARVESTING) {
            throw new IllegalStateException(String.format("Cannot abort a harvest when it is '%s'!", this.combinedStateHistory.toString()));
        }
        this.setStatus(ETLState.ABORTING);
        this.processETLs(harvester -> {
            if (harvester.getState() == ETLState.HARVESTING || harvester.getState() == ETLState.QUEUED) {
                harvester.abortHarvest();
            }
        });
    }

    public String getHash() {
        StringBuffer hashBuilder = new StringBuffer();
        for (AbstractETL etl : this.etls) {
            if (!etl.isEnabled()) continue;
            String subHash = etl.getHash();
            if (subHash == null) {
                return null;
            }
            hashBuilder.append(subHash);
        }
        if (hashBuilder.length() == 0) {
            return null;
        }
        HashGenerator generator = new HashGenerator(StandardCharsets.UTF_8);
        return generator.getShaHash(hashBuilder.toString());
    }

    public int getHarvestedCount() {
        return this.sumUpETLValues(harvester -> harvester.getHarvestedCount());
    }

    public ETLHealth getHealth() {
        List healthStatuses = this.processETLs(harvester -> harvester.getHealth());
        ETLHealth overallHealth = ETLHealth.OK;
        if (healthStatuses.contains(ETLHealth.INITIALIZATION_FAILED)) {
            overallHealth = ETLHealth.INITIALIZATION_FAILED;
        } else if (healthStatuses.contains(ETLHealth.HARVEST_FAILED)) {
            overallHealth = ETLHealth.HARVEST_FAILED;
        } else {
            if (healthStatuses.contains(ETLHealth.EXTRACTION_FAILED)) {
                overallHealth = ETLHealth.EXTRACTION_FAILED;
            }
            if (healthStatuses.contains(ETLHealth.TRANSFORMATION_FAILED)) {
                ETLHealth eTLHealth = overallHealth = overallHealth == ETLHealth.OK ? ETLHealth.TRANSFORMATION_FAILED : ETLHealth.HARVEST_FAILED;
            }
            if (healthStatuses.contains(ETLHealth.LOADING_FAILED)) {
                overallHealth = overallHealth == ETLHealth.OK ? ETLHealth.LOADING_FAILED : ETLHealth.HARVEST_FAILED;
            }
        }
        return overallHealth;
    }

    public ETLState getState() {
        return (ETLState)this.combinedStateHistory.getLatestValue();
    }

    public long estimateRemainingHarvestTime() {
        return this.estimateRemainingHarvestTime(this.getHarvestedCount(), this.getMaxNumberOfDocuments());
    }

    private long getLatestHarvestTimestamp() {
        Iterator reverseIter = this.combinedStateHistory.descendingIterator();
        while (reverseIter.hasNext()) {
            TimestampedEntry item = (TimestampedEntry)reverseIter.next();
            if (item.getValue() != ETLState.HARVESTING) continue;
            return item.getTimestamp();
        }
        return -1L;
    }

    private boolean prepareETLsForHarvest() {
        LOGGER.info("Preparing ETLs for harvest.");
        this.setStatus(ETLState.QUEUED);
        int preparedCount = this.sumUpETLValues(harvester -> {
            try {
                if (this.getState() != ETLState.ABORTING) {
                    harvester.prepareHarvest();
                    return 1;
                }
            }
            catch (ETLPreconditionException e) {
                LOGGER.info(e.getMessage());
            }
            return 0;
        });
        if (preparedCount == 0 || this.getState() == ETLState.ABORTING) {
            this.setStatus(ETLState.IDLE);
            return false;
        }
        return true;
    }

    private void harvestETLs() {
        LOGGER.info("Starting ETLs.");
        this.setStatus(ETLState.HARVESTING);
        EventSystem.sendEvent((IEvent)new HarvestStartedEvent(this.getHash(), this.getMaxNumberOfDocuments()));
        if (((Boolean)this.concurrentParam.getValue()).booleanValue()) {
            List asyncHarvests = this.processETLs(etl -> CompletableFuture.runAsync(() -> {
                if (this.getState() != ETLState.ABORTING && etl.getState() == ETLState.QUEUED) {
                    etl.harvest();
                }
            }));
            try {
                CompletableFuture[] asyncHarvestArray = asyncHarvests.toArray(new CompletableFuture[asyncHarvests.size()]);
                CompletableFuture.allOf(asyncHarvestArray).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Error iterating through ETL components!", (Throwable)e);
            }
        } else {
            this.processETLs(etl -> {
                if (this.getState() != ETLState.ABORTING && etl.getState() == ETLState.QUEUED) {
                    etl.harvest();
                }
            });
        }
    }

    private <T> List<T> processETLs(Function<AbstractETL<?, ?>, T> function) {
        ArrayList<T> returnValues = new ArrayList<T>(this.etls.size());
        for (AbstractETL etl : this.etls) {
            if (!etl.isEnabled()) continue;
            returnValues.add(function.apply(etl));
        }
        return returnValues;
    }

    private void processETLs(Consumer<AbstractETL<?, ?>> consumer) {
        for (AbstractETL etl : this.etls) {
            if (!etl.isEnabled()) continue;
            consumer.accept(etl);
        }
    }

    private int sumUpETLValues(Function<AbstractETL<?, ?>, Integer> intFunction) {
        List processedData = this.processETLs(intFunction);
        int total = 0;
        Iterator iterator = processedData.iterator();
        while (iterator.hasNext()) {
            int pd = (Integer)iterator.next();
            total += pd;
        }
        return total;
    }

    private void setStatus(ETLState status) {
        this.combinedStateHistory.addValue((Object)status);
    }

    private long estimateRemainingHarvestTime(int harvestedDocuments, int maxDocuments) {
        ETLState currentStatus = (ETLState)this.combinedStateHistory.getLatestValue();
        if (currentStatus != ETLState.HARVESTING) {
            return -1L;
        }
        if (maxDocuments == -1) {
            return -1L;
        }
        if (harvestedDocuments == 0) {
            return -1L;
        }
        long harvestStartTimestamp = this.combinedStateHistory.getLatestTimestamp();
        long millisSinceHarvestStarted = System.currentTimeMillis() - harvestStartTimestamp;
        long averageMillisPerDocument = millisSinceHarvestStarted / (long)harvestedDocuments;
        return averageMillisPerDocument * (long)(maxDocuments - harvestedDocuments);
    }

    private static String getDurationText(long milliseconds) {
        if (milliseconds < 0L || milliseconds == Long.MAX_VALUE) {
            return "Remaining Time : ???";
        }
        long hours = milliseconds / 3600000L;
        return String.format("Remaining Time: %1$02d:%2$tM:%2$tS", hours, milliseconds);
    }
}

