/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.loaders.utils;

import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.StringParameter;
import de.gerdiproject.harvest.config.parameters.constants.ParameterMappingFunctions;
import de.gerdiproject.harvest.etls.loaders.ILoader;
import de.gerdiproject.harvest.etls.loaders.events.CreateLoaderEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class LoaderRegistry
implements IEventListener {
    private final Map<String, Class<? extends ILoader<?>>> loaderMap = new HashMap();
    private StringParameter loaderParam;

    public LoaderRegistry() {
        Function paramChangeGuard = ParameterMappingFunctions.createMapperForETLs((Function)ParameterMappingFunctions.createStringListMapper(this.loaderMap.keySet()));
        this.loaderParam = new StringParameter("loader", "Submission", null, paramChangeGuard);
    }

    public void registerLoader(Class<? extends ILoader<?>> loaderClass) {
        String loaderName = loaderClass.getSimpleName();
        this.loaderMap.put(loaderName, loaderClass);
        if (!this.loaderParam.isRegistered() && this.loaderParam.getValue() == null) {
            this.loaderParam.setValue(loaderName);
            this.loaderParam = (StringParameter)Configuration.registerParameter((AbstractParameter)this.loaderParam);
        }
    }

    public void addEventListeners() {
        EventSystem.addSynchronousListener(CreateLoaderEvent.class, () -> this.createLoader());
    }

    public void removeEventListeners() {
        EventSystem.removeSynchronousListener(CreateLoaderEvent.class);
    }

    private ILoader<?> createLoader() {
        Class loaderClass = (Class)this.loaderMap.get(this.loaderParam.getValue());
        try {
            return (ILoader)loaderClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }
}

