/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.loaders;

import com.google.gson.Gson;
import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.etls.loaders.AbstractURLLoader;
import de.gerdiproject.harvest.etls.loaders.constants.ElasticSearchConstants;
import de.gerdiproject.harvest.etls.loaders.json.ElasticSearchError;
import de.gerdiproject.harvest.etls.loaders.json.ElasticSearchIndex;
import de.gerdiproject.harvest.etls.loaders.json.ElasticSearchIndexWrapper;
import de.gerdiproject.harvest.etls.loaders.json.ElasticSearchResponse;
import de.gerdiproject.harvest.utils.data.WebDataRetriever;
import de.gerdiproject.harvest.utils.data.enums.RestRequestType;
import de.gerdiproject.json.GsonUtils;
import de.gerdiproject.json.datacite.DataCiteJson;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public class ElasticSearchLoader
extends AbstractURLLoader<DataCiteJson> {
    private final Gson gson = GsonUtils.createGerdiDocumentGsonBuilder().create();
    private final WebDataRetriever webRequester = new WebDataRetriever(this.gson, StandardCharsets.UTF_8);

    protected void loadBatch(Map<String, IDocument> documents) throws Exception {
        StringBuilder batchRequestBuilder = new StringBuilder();
        for (Map.Entry<String, IDocument> entry : documents.entrySet()) {
            String documentAddInstruction = this.createBulkInstruction(entry.getKey(), entry.getValue());
            batchRequestBuilder.append(documentAddInstruction);
        }
        String response = this.webRequester.getRestResponse(RestRequestType.POST, this.getUrl(), batchRequestBuilder.toString(), this.getCredentials(), "application/json");
        ElasticSearchResponse responseJson = (ElasticSearchResponse)this.gson.fromJson(response, ElasticSearchResponse.class);
        if (responseJson.hasErrors()) {
            this.logger.error(this.getSubmissionErrorText(responseJson));
            Map fixedDocuments = this.fixInvalidDocuments(responseJson, documents);
            if (!fixedDocuments.isEmpty()) {
                this.logger.warn("Resubmitting documents after removing invalid fields.");
                this.loadBatch(fixedDocuments);
            }
        }
    }

    private String getSubmissionErrorText(ElasticSearchResponse responseJson) {
        List loadedItems = responseJson.getItems();
        StringBuilder sb = new StringBuilder();
        int l = loadedItems.size();
        for (int i = 0; i < l; ++i) {
            ElasticSearchIndex indexElement = ((ElasticSearchIndexWrapper)loadedItems.get(i)).getIndex();
            if (indexElement.getError() == null) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(indexElement.getErrorText());
        }
        return sb.toString();
    }

    private String createBulkInstruction(String documentId, IDocument doc) {
        String bulkInstruction;
        if (doc != null) {
            String jsonString = this.charset != StandardCharsets.UTF_8 ? new String(this.toElasticSearchJson(doc).getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8) : this.toElasticSearchJson(doc);
            bulkInstruction = String.format("{\"index\":{\"_id\":\"%s\"}}%n%s%n", documentId, jsonString);
        } else {
            bulkInstruction = String.format("{\"delete\":{\"_id\":\"%s\"}}%n", documentId);
        }
        return bulkInstruction;
    }

    private String toElasticSearchJson(IDocument document) {
        String jsonString = document.toJson();
        return jsonString.replaceAll("\"value\":\"(\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d[^\"]*?Z)?/(\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d[^\"]*?Z)?\"", "\"value\":\\{\"gte\":\"$1\",\"lte\":\"$2\"\\}").replaceAll("\"value\":(\"\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d[^\"/]*Z\")", "\"value\":\\{\"gte\":$1,\"lte\":$1\\}");
    }

    private Map<String, IDocument> fixInvalidDocuments(ElasticSearchResponse response, Map<String, IDocument> documents) {
        HashMap<String, IDocument> fixedDocMap = new HashMap<String, IDocument>();
        for (ElasticSearchIndexWrapper documentFeedback : response.getItems()) {
            String documentId;
            IDocument doc;
            ElasticSearchError docError = documentFeedback.getIndex().getError();
            if (docError == null || (doc = documents.get(documentId = documentFeedback.getIndex().getId())) == null || !this.tryFixInvalidDocument(doc, docError)) continue;
            fixedDocMap.put(documentId, doc);
        }
        return fixedDocMap;
    }

    private boolean tryFixInvalidDocument(IDocument errorDocument, ElasticSearchError docError) {
        Matcher errorReasonMatcher = ElasticSearchConstants.PARSE_ERROR_REASON_PATTERN.matcher(docError.getReason());
        if (errorReasonMatcher.find()) {
            String invalidFieldName = errorReasonMatcher.group(1);
            try {
                Field invalidField = errorDocument.getClass().getDeclaredField(invalidFieldName);
                boolean accessibility = invalidField.isAccessible();
                invalidField.setAccessible(true);
                invalidField.set(errorDocument, null);
                invalidField.setAccessible(accessibility);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                this.logger.warn(String.format("Could not remove invalid field '%s' from Document %s!", invalidFieldName, errorDocument.getSourceId()));
            }
        }
        return false;
    }

    protected String getUrl() {
        if (this.urlParam.getValue() != null) {
            String rawPath;
            try {
                rawPath = new URL((String)this.urlParam.getValue()).getPath() + '/';
            }
            catch (MalformedURLException e) {
                this.logger.error(String.format("Invalid Elasticsearch API URL: %s", this.urlParam.getValue()));
                return null;
            }
            String[] path = rawPath.substring(1).split("/");
            String bulkSubmitUrl = this.urlParam.getStringValue();
            if (path.length == 0 || !path[path.length - 1].equals("_bulk")) {
                int queryIndex = bulkSubmitUrl.indexOf(63);
                if (queryIndex != -1) {
                    bulkSubmitUrl = bulkSubmitUrl.substring(0, queryIndex);
                }
                if (bulkSubmitUrl.charAt(bulkSubmitUrl.length() - 1) != '/') {
                    bulkSubmitUrl = bulkSubmitUrl + '/';
                }
                bulkSubmitUrl = bulkSubmitUrl + "_bulk";
            }
            return bulkSubmitUrl;
        }
        return null;
    }

    protected String getCredentials() {
        String credentials = super.getCredentials();
        if (credentials != null) {
            return "Basic " + credentials;
        }
        return null;
    }

    protected int getSizeOfDocument(String documentId, IDocument document) {
        return this.createBulkInstruction(documentId, document).getBytes(StandardCharsets.UTF_8).length;
    }
}

