/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.loaders;

import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.IntegerParameter;
import de.gerdiproject.harvest.config.parameters.StringParameter;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.loaders.AbstractIteratorLoader;
import de.gerdiproject.harvest.etls.loaders.LoaderException;
import de.gerdiproject.harvest.etls.loaders.constants.LoaderConstants;
import de.gerdiproject.harvest.utils.HashGenerator;
import de.gerdiproject.json.datacite.DataCiteJson;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractURLLoader<S extends DataCiteJson>
extends AbstractIteratorLoader<S> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, IDocument> batchMap = new HashMap();
    protected final IntegerParameter maxBatchSizeParam;
    protected final StringParameter urlParam = (StringParameter)Configuration.registerParameter((AbstractParameter)LoaderConstants.URL_PARAM);
    protected final HashGenerator hashGenerator;
    protected volatile Charset charset;
    private final StringParameter userNameParam = (StringParameter)Configuration.registerParameter((AbstractParameter)LoaderConstants.USER_NAME_PARAM);
    private final StringParameter passwordParam = (StringParameter)Configuration.registerParameter((AbstractParameter)LoaderConstants.PASSWORD_PARAM);
    private int currentBatchSize = 0;

    public AbstractURLLoader() {
        this.maxBatchSizeParam = (IntegerParameter)Configuration.registerParameter((AbstractParameter)LoaderConstants.MAX_BATCH_SIZE_PARAM);
        this.hashGenerator = new HashGenerator(StandardCharsets.UTF_8);
    }

    public void unregisterParameters() {
        Configuration.unregisterParameter((AbstractParameter)this.urlParam);
        Configuration.unregisterParameter((AbstractParameter)this.userNameParam);
        Configuration.unregisterParameter((AbstractParameter)this.passwordParam);
        Configuration.unregisterParameter((AbstractParameter)this.maxBatchSizeParam);
    }

    public void init(AbstractETL<?, ?> etl) {
        super.init(etl);
        this.batchMap.clear();
        this.currentBatchSize = 0;
        this.charset = etl.getCharset();
        String errorMessage = this.checkPreconditionErrors();
        if (errorMessage != null) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public void load(Iterator<S> documents) throws LoaderException {
        super.load(documents);
        if (!this.batchMap.isEmpty()) {
            this.tryLoadingBatch();
            this.batchMap.clear();
        }
    }

    public void loadElement(S document) throws LoaderException {
        if (document == null) {
            return;
        }
        String documentId = this.hashGenerator.getShaHash(document.getSourceId());
        int documentSize = this.getSizeOfDocument(documentId, document);
        if (this.currentBatchSize == 0 && documentSize > (Integer)this.maxBatchSizeParam.getValue()) {
            throw new LoaderException(String.format("Loader Error: Size of document %s is %d bytes, which is larger than the maximum permitted size of %d bytes.", documentId, documentSize, this.maxBatchSizeParam.getValue()));
        }
        if (this.currentBatchSize + documentSize > (Integer)this.maxBatchSizeParam.getValue()) {
            this.tryLoadingBatch();
            this.batchMap.clear();
            this.currentBatchSize = 0;
        }
        this.batchMap.put(documentId, document);
        this.currentBatchSize += documentSize;
    }

    public void clear() {
        if (!this.batchMap.isEmpty()) {
            try {
                this.tryLoadingBatch();
            }
            catch (LoaderException e) {
                this.logger.warn("Loader Error: Unable to submit partially harvested documents while cancelling the harvest!", (Throwable)e);
            }
            this.batchMap.clear();
        }
        this.currentBatchSize = 0;
    }

    protected abstract int getSizeOfDocument(String var1, IDocument var2);

    protected abstract void loadBatch(Map<String, IDocument> var1) throws Exception;

    protected String checkPreconditionErrors() {
        String url = this.getUrl();
        if (url == null || url.isEmpty()) {
            return "Loader Error: You need to set up a valid loader URL!";
        }
        return null;
    }

    protected void tryLoadingBatch() throws LoaderException {
        int numberOfDocs = this.batchMap.size();
        try {
            this.loadBatch(this.batchMap);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("Loaded %d documents.", numberOfDocs));
            }
        }
        catch (Exception e) {
            throw new LoaderException((Throwable)e);
        }
    }

    protected String getCredentials() {
        if (this.userNameParam.getValue() == null || this.passwordParam.getValue() == null || ((String)this.userNameParam.getValue()).isEmpty()) {
            return null;
        }
        return Base64.getEncoder().encodeToString(((String)this.userNameParam.getValue() + ":" + (String)this.passwordParam.getValue()).getBytes(StandardCharsets.UTF_8));
    }

    protected String getUrl() {
        return this.urlParam.getStringValue();
    }
}

