/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.extractors;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.extractors.AbstractIteratorExtractor;
import de.gerdiproject.harvest.etls.extractors.ExtractorException;
import de.gerdiproject.harvest.utils.HashGenerator;
import de.gerdiproject.harvest.utils.data.HttpRequester;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JsonArrayExtractor<T>
extends AbstractIteratorExtractor<T> {
    private final Class<T> outputClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private final Gson gson;
    private final String jsonQuery;
    private final HttpRequester httpRequester;
    private String url;
    private String hash;
    private List<T> extractedList;

    public JsonArrayExtractor(Gson gson, String jsonQuery) {
        this.jsonQuery = jsonQuery;
        this.httpRequester = new HttpRequester(gson, StandardCharsets.UTF_8);
        this.gson = gson;
    }

    public JsonArrayExtractor(Gson gson) {
        this(gson, null);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void init(AbstractETL<?, ?> etl) {
        super.init(etl);
        JsonElement jsonResponse = (JsonElement)this.httpRequester.getObjectFromUrl(this.url, JsonElement.class);
        this.extractedList = this.getListFromJson(jsonResponse);
        this.hash = this.getHashFromJson(jsonResponse);
    }

    public Iterator<T> extractAll() {
        return this.extractedList.listIterator();
    }

    public int size() {
        return this.extractedList.size();
    }

    public String getUniqueVersionString() {
        return this.hash;
    }

    protected String getHashFromJson(JsonElement json) {
        HashGenerator gen = new HashGenerator(StandardCharsets.UTF_8);
        return gen.getShaHash(json.toString());
    }

    protected List<T> getListFromJson(JsonElement json) throws ExtractorException {
        if (this.jsonQuery != null) {
            for (String q : this.jsonQuery.split("\\.")) {
                json = json.getAsJsonObject().get(q);
            }
        }
        if (!json.isJsonArray()) {
            throw new ExtractorException("%s did not yield a JSON-Array at '%s'!");
        }
        LinkedList<Object> list = new LinkedList<Object>();
        JsonArray sourceArray = json.getAsJsonArray();
        for (JsonElement ele : sourceArray) {
            list.add(this.gson.fromJson(ele, this.outputClass));
        }
        return list;
    }

    public void clear() {
    }
}

