/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.extractors;

import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.AbstractIteratorETL;
import de.gerdiproject.harvest.etls.extractors.AbstractIteratorExtractor;
import de.gerdiproject.harvest.etls.extractors.ExtractorException;
import de.gerdiproject.harvest.etls.extractors.IExtractor;
import java.util.Iterator;

public abstract class AbstractIteratorExtractor<T>
implements IExtractor<Iterator<T>> {
    protected int startIndex;
    protected int endIndex;

    public void init(AbstractETL<?, ?> etl) {
        if (etl instanceof AbstractIteratorETL) {
            AbstractIteratorETL iterHarvester = (AbstractIteratorETL)etl;
            this.startIndex = iterHarvester.getStartIndex();
            this.endIndex = iterHarvester.getEndIndex();
        }
    }

    protected abstract Iterator<T> extractAll() throws ExtractorException;

    public Iterator<T> extract() throws ExtractorException {
        if (this.endIndex == Integer.MAX_VALUE && this.startIndex == 0) {
            return this.extractAll();
        }
        return new RangeRestrictedIterator(this, this.extractAll());
    }

    public int size() {
        if (this.endIndex == Integer.MAX_VALUE) {
            return -1;
        }
        return this.endIndex - this.startIndex;
    }

    public void clear() {
    }
}

