/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.gerdiproject.harvest.etls.json.ETLJson;
import de.gerdiproject.harvest.etls.utils.TimestampedList;
import java.lang.reflect.Type;
import java.util.List;

public class ETLJsonAdapter
implements JsonDeserializer<ETLJson> {
    public ETLJson deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement nameEle = jsonObject.get("name");
        String name = nameEle != null ? nameEle.getAsString() : null;
        JsonElement versionHashEle = jsonObject.get("versionHash");
        String versionHash = versionHashEle != null ? versionHashEle.getAsString() : null;
        JsonElement harvestedCountEle = jsonObject.get("harvestedCount");
        int harvestedCount = harvestedCountEle != null ? harvestedCountEle.getAsInt() : 0;
        JsonElement maxDocumentCountEle = jsonObject.get("maxDocumentCount");
        int maxDocumentCount = maxDocumentCountEle != null ? maxDocumentCountEle.getAsInt() : 1;
        JsonElement statusHistoryEle = jsonObject.get("statusHistory");
        Type statusHistoryType = new /* Unavailable Anonymous Inner Class!! */.getType();
        TimestampedList statusHistory = (TimestampedList)context.deserialize(statusHistoryEle, statusHistoryType);
        JsonElement healthHistoryEle = jsonObject.get("healthHistory");
        Type healthHistoryType = new /* Unavailable Anonymous Inner Class!! */.getType();
        TimestampedList healthHistory = (TimestampedList)context.deserialize(healthHistoryEle, healthHistoryType);
        return new ETLJson(name, (List)statusHistory, (List)healthHistory, harvestedCount, maxDocumentCount, versionHash);
    }
}

