/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls;

import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.IntegerParameter;
import de.gerdiproject.harvest.config.parameters.constants.ParameterMappingFunctions;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.ETLPreconditionException;
import de.gerdiproject.harvest.etls.constants.ETLConstants;
import de.gerdiproject.harvest.etls.extractors.AbstractIteratorExtractor;
import de.gerdiproject.harvest.etls.json.ETLJson;
import de.gerdiproject.harvest.etls.loaders.AbstractIteratorLoader;
import de.gerdiproject.harvest.etls.transformers.AbstractIteratorTransformer;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractIteratorETL<T, S>
extends AbstractETL<Iterator<T>, Iterator<S>> {
    protected volatile IntegerParameter startIndexParameter;
    protected volatile IntegerParameter endIndexParameter;
    protected final AtomicInteger harvestedCount = new AtomicInteger(0);

    public AbstractIteratorETL() {
    }

    public AbstractIteratorETL(String name) {
        super(name);
    }

    protected void registerParameters() {
        super.registerParameters();
        this.startIndexParameter = (IntegerParameter)Configuration.registerParameter((AbstractParameter)new IntegerParameter("rangeFrom", this.getName(), 0, ParameterMappingFunctions.createMapperForETL(ParameterMappingFunctions::mapToUnsignedInteger, (AbstractETL)this)));
        this.endIndexParameter = (IntegerParameter)Configuration.registerParameter((AbstractParameter)new IntegerParameter("rangeTo", this.getName(), Integer.MAX_VALUE, ParameterMappingFunctions.createMapperForETL(ParameterMappingFunctions::mapToUnsignedInteger, (AbstractETL)this)));
    }

    public void loadFromJson(ETLJson json) {
        super.loadFromJson(json);
        this.harvestedCount.set(json.getHarvestedCount());
    }

    public void prepareHarvest() throws ETLPreconditionException {
        super.prepareHarvest();
        if (this.getStartIndex() == this.getEndIndex()) {
            throw new ETLPreconditionException(String.format("Skipping %s - Document indices out of range.", this.getName()));
        }
        if (!(this.extractor instanceof AbstractIteratorExtractor)) {
            throw new ETLPreconditionException(ETLConstants.INVALID_ITER_EXTRACTOR_ERROR);
        }
        if (!(this.transformer instanceof AbstractIteratorTransformer)) {
            throw new ETLPreconditionException(ETLConstants.INVALID_ITER_TRANSFORMER_ERROR);
        }
        if (!(this.loader instanceof AbstractIteratorLoader)) {
            throw new ETLPreconditionException(ETLConstants.INVALID_ITER_LOADER_ERROR);
        }
        this.harvestedCount.set(0);
    }

    public int getHarvestedCount() {
        return this.harvestedCount.get();
    }

    public int getMaxNumberOfDocuments() {
        int unrestrictedMaxDocs = super.getMaxNumberOfDocuments();
        if (unrestrictedMaxDocs == -1) {
            return this.getEndIndex() != Integer.MAX_VALUE ? this.getEndIndex() - this.getStartIndex() : -1;
        }
        return Math.min(unrestrictedMaxDocs, this.getEndIndex()) - this.getStartIndex();
    }

    public int getStartIndex() {
        int index = (Integer)this.startIndexParameter.getValue();
        if (index < 0) {
            return 0;
        }
        return index;
    }

    public int getEndIndex() {
        int index = (Integer)this.endIndexParameter.getValue();
        if (index < 0) {
            return 0;
        }
        return index;
    }

    public void incrementHarvestedDocuments() {
        this.harvestedCount.incrementAndGet();
    }

    protected void onParameterChanged(AbstractParameter<?> param) {
        super.onParameterChanged(param);
        String paramKey = param.getCompositeKey();
        if (this.extractor != null && (paramKey.equals(this.startIndexParameter.getCompositeKey()) || paramKey.equals(this.endIndexParameter.getCompositeKey()))) {
            this.extractor.init((AbstractETL)this);
        }
    }
}

