/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.etls;

import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.application.events.ResetContextEvent;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.events.ParameterChangedEvent;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.BooleanParameter;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.ETLPreconditionException;
import de.gerdiproject.harvest.etls.constants.ETLConstants;
import de.gerdiproject.harvest.etls.enums.ETLHealth;
import de.gerdiproject.harvest.etls.enums.ETLState;
import de.gerdiproject.harvest.etls.events.HarvestFinishedEvent;
import de.gerdiproject.harvest.etls.extractors.ExtractorException;
import de.gerdiproject.harvest.etls.extractors.IExtractor;
import de.gerdiproject.harvest.etls.json.ETLJson;
import de.gerdiproject.harvest.etls.loaders.ILoader;
import de.gerdiproject.harvest.etls.loaders.LoaderException;
import de.gerdiproject.harvest.etls.loaders.events.CreateLoaderEvent;
import de.gerdiproject.harvest.etls.transformers.ITransformer;
import de.gerdiproject.harvest.etls.transformers.TransformerException;
import de.gerdiproject.harvest.etls.utils.TimestampedEntry;
import de.gerdiproject.harvest.etls.utils.TimestampedList;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEventListener;
import de.gerdiproject.harvest.event.ISynchronousEvent;
import de.gerdiproject.harvest.utils.HashGenerator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractETL<T, S>
implements IEventListener {
    protected IExtractor<T> extractor;
    protected ITransformer<T, S> transformer;
    protected ILoader<S> loader;
    protected volatile BooleanParameter enabledParameter;
    private AtomicInteger maxDocumentCount;
    protected final Logger logger;
    protected String name;
    protected volatile String hash;
    protected final TimestampedList<ETLHealth> healthHistory;
    protected final TimestampedList<ETLState> stateHistory;
    private final Consumer<ResetContextEvent> onResetContextCallback = event -> this.onResetContext();
    private final Consumer<HarvestFinishedEvent> onHarvestFinishedCallback = event -> this.onHarvestFinished(event.isSuccessful());
    private final Consumer<ParameterChangedEvent> onParameterChangedCallback = event -> this.onParameterChanged(event.getParameter());
    private final Consumer<ContextDestroyedEvent> onContextDestroyedCallback = event -> this.onContextDestroyed();

    public AbstractETL() {
        this(null);
    }

    public AbstractETL(String name) {
        this.stateHistory = new TimestampedList((Object)ETLState.INITIALIZING, 10);
        this.healthHistory = new TimestampedList((Object)ETLHealth.OK, 1);
        this.name = name != null ? name : this.getClass().getSimpleName();
        this.logger = LoggerFactory.getLogger((String)this.getName());
        this.maxDocumentCount = new AtomicInteger(0);
    }

    protected abstract IExtractor<T> createExtractor();

    protected abstract ITransformer<T, S> createTransformer();

    protected ILoader<S> createLoader() {
        try {
            return (ILoader)EventSystem.sendSynchronousEvent((ISynchronousEvent)new CreateLoaderEvent());
        }
        catch (ClassCastException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    protected void registerParameters() {
        this.enabledParameter = (BooleanParameter)Configuration.registerParameter((AbstractParameter)new BooleanParameter(ETLConstants.ENABLED_PARAM.getKey(), this.getName(), ((Boolean)ETLConstants.ENABLED_PARAM.getValue()).booleanValue(), ETLConstants.ENABLED_PARAM.getMappingFunction()));
    }

    public void addEventListeners() {
        EventSystem.addListener(ResetContextEvent.class, (Consumer)this.onResetContextCallback);
        EventSystem.addListener(ContextDestroyedEvent.class, (Consumer)this.onContextDestroyedCallback);
        EventSystem.addListener(ParameterChangedEvent.class, (Consumer)this.onParameterChangedCallback);
        EventSystem.addListener(HarvestFinishedEvent.class, (Consumer)this.onHarvestFinishedCallback);
    }

    public void removeEventListeners() {
        EventSystem.removeListener(ResetContextEvent.class, (Consumer)this.onResetContextCallback);
        EventSystem.removeListener(ContextDestroyedEvent.class, (Consumer)this.onContextDestroyedCallback);
        EventSystem.removeListener(ParameterChangedEvent.class, (Consumer)this.onParameterChangedCallback);
        EventSystem.removeListener(HarvestFinishedEvent.class, (Consumer)this.onHarvestFinishedCallback);
    }

    public void loadFromJson(ETLJson json) {
        this.stateHistory.addAllSorted((Collection)json.getStateHistory());
        List loadedHealthHistory = json.getHealthHistory();
        if (loadedHealthHistory != null && this.getHealth() == ETLHealth.OK && ((TimestampedEntry)loadedHealthHistory.get(0)).getValue() != ETLHealth.INITIALIZATION_FAILED) {
            this.healthHistory.clear();
            this.healthHistory.addAllSorted((Collection)loadedHealthHistory);
        }
    }

    public ETLJson getAsJson() {
        return new ETLJson(this.getName(), (List)this.stateHistory, (List)this.healthHistory, this.getHarvestedCount(), this.getMaxNumberOfDocuments(), this.getHash());
    }

    public void abortHarvest() throws IllegalStateException {
        switch (1.$SwitchMap$de$gerdiproject$harvest$etls$enums$ETLState[this.getState().ordinal()]) {
            case 1: {
                this.setStatus(ETLState.ABORTING);
                break;
            }
            case 2: {
                this.cancelHarvest();
                this.setStatus(ETLState.DONE);
                break;
            }
        }
    }

    public void init(String moduleName) throws IllegalStateException {
        if (this.getState() != ETLState.INITIALIZING) {
            throw new IllegalStateException("ETLs must not be initialized more than once!");
        }
        this.registerParameters();
        this.extractor = this.createExtractor();
        this.transformer = this.createTransformer();
        this.loader = this.createLoader();
        this.setStatus(ETLState.IDLE);
    }

    protected int initMaxNumberOfDocuments() {
        return this.extractor.size();
    }

    protected String initHash() {
        String versionString = this.extractor.getUniqueVersionString();
        if (versionString != null) {
            HashGenerator generator = new HashGenerator(StandardCharsets.UTF_8);
            return generator.getShaHash(versionString);
        }
        return null;
    }

    public void update() throws ETLPreconditionException {
        this.extractor = this.createExtractor();
        if (this.extractor == null) {
            throw new ETLPreconditionException(String.format("Could not create EXTRACTOR for %s!", this.getName()));
        }
        try {
            this.extractor.init(this);
        }
        catch (RuntimeException e) {
            throw new ETLPreconditionException((Throwable)e);
        }
        try {
            this.hash = this.initHash();
        }
        catch (NullPointerException e) {
            this.logger.error(String.format("Failed to create hash for %s!", this.getName()), (Throwable)e);
            this.hash = null;
        }
        this.maxDocumentCount.set(this.initMaxNumberOfDocuments());
    }

    public int getMaxNumberOfDocuments() {
        return this.maxDocumentCount.get();
    }

    public void prepareHarvest() throws ETLPreconditionException {
        this.setStatus(ETLState.QUEUED);
        this.setHealth(ETLHealth.OK);
        if (!((Boolean)this.enabledParameter.getValue()).booleanValue()) {
            this.skipHarvest();
            throw new ETLPreconditionException(String.format("Skipping %s, because it is disabled!", this.getName()));
        }
        try {
            this.update();
            if (this.transformer == null) {
                throw new ETLPreconditionException(String.format("Could not create TRANSFORMER for %s!", this.getName()));
            }
            if (this.loader == null) {
                throw new ETLPreconditionException(String.format("Could not create LOADER for %s!", this.getName()));
            }
            this.transformer.init(this);
            this.loader.init(this);
        }
        catch (ETLPreconditionException e) {
            this.setStatus(ETLState.DONE);
            this.setHealth(ETLHealth.HARVEST_FAILED);
            throw e;
        }
        catch (Exception e) {
            this.setStatus(ETLState.DONE);
            this.setHealth(ETLHealth.HARVEST_FAILED);
            this.logger.error(String.format("%s could not be started due to an unexpected error!", this.getName()), (Throwable)e);
            throw new ETLPreconditionException(e.getMessage(), (Throwable)e);
        }
    }

    public void cancelHarvest() {
        switch (1.$SwitchMap$de$gerdiproject$harvest$etls$enums$ETLState[this.getState().ordinal()]) {
            case 1: 
            case 2: {
                this.setStatus(ETLState.CANCELLING);
                this.loader.clear();
                this.transformer.clear();
                this.extractor.clear();
                this.setStatus(ETLState.DONE);
                break;
            }
        }
    }

    protected void skipHarvest() {
        this.setHealth(ETLHealth.OK);
        this.setStatus(ETLState.DONE);
    }

    public final void harvest() {
        try {
            this.logger.info(String.format("Starting %s...", this.getName()));
            this.setStatus(ETLState.HARVESTING);
            Object exOut = this.extractor.extract();
            Object transOut = this.transformer.transform(exOut);
            this.loader.load(transOut);
            this.loader.clear();
            this.transformer.clear();
            this.extractor.clear();
            if (this.getState() == ETLState.ABORTING) {
                this.logger.info(String.format("%s aborted!", this.getName()));
            } else {
                this.logger.info(String.format("%s finished!", this.getName()));
            }
            this.setStatus(ETLState.DONE);
        }
        catch (Exception e) {
            this.finishHarvestExceptionally((Throwable)e);
        }
    }

    protected void finishHarvestExceptionally(Throwable reason) {
        if (this.getState() == ETLState.ABORTING) {
            this.logger.info(String.format("%s aborted!", this.getName()));
        } else {
            if (reason instanceof ExtractorException) {
                this.setHealth(ETLHealth.EXTRACTION_FAILED);
            } else if (reason instanceof TransformerException) {
                this.setHealth(ETLHealth.TRANSFORMATION_FAILED);
            } else if (reason instanceof LoaderException) {
                this.setHealth(ETLHealth.LOADING_FAILED);
            } else {
                this.setHealth(ETLHealth.HARVEST_FAILED);
            }
            this.logger.error(reason.getMessage(), reason);
            this.logger.warn(String.format("%s failed!", this.getName()));
        }
        this.loader.clear();
        this.transformer.clear();
        this.extractor.clear();
        this.setStatus(ETLState.DONE);
    }

    public String getHash() {
        return this.hash;
    }

    public ETLState getState() {
        return (ETLState)this.stateHistory.getLatestValue();
    }

    public void setStatus(ETLState state) {
        this.stateHistory.addValue((Object)state);
    }

    public ETLHealth getHealth() {
        return (ETLHealth)this.healthHistory.getLatestValue();
    }

    public void setHealth(ETLHealth health) {
        this.healthHistory.addValue((Object)health);
    }

    public abstract int getHarvestedCount();

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public boolean isEnabled() {
        return (Boolean)this.enabledParameter.getValue() != false && this.getHealth() != ETLHealth.INITIALIZATION_FAILED;
    }

    public String toString() {
        String etlStatus = this.getState().toString().toLowerCase();
        if (!((Boolean)this.enabledParameter.getValue()).booleanValue()) {
            etlStatus = "disabled";
        } else if (this.getState() == ETLState.HARVESTING) {
            int currCount = this.getHarvestedCount();
            int maxCount = this.getMaxNumberOfDocuments();
            etlStatus = maxCount != -1 ? etlStatus + String.format(" % 3d%% (%d / %d)", Math.round(100.0f * (float)currCount / (float)maxCount), currCount, maxCount) : etlStatus + String.format(" (%d / ???)", currCount);
        }
        return String.format("%s : %s [Health: %s]%n", this.getName(), etlStatus, this.getHealth().toString());
    }

    protected void onResetContext() {
        this.cancelHarvest();
    }

    protected void onHarvestFinished(boolean wasSuccessful) {
        if (this.getState() == ETLState.DONE) {
            this.setStatus(ETLState.IDLE);
        }
    }

    protected void onParameterChanged(AbstractParameter<?> param) {
        if (param.getKey().equals("loader") && param.getCategory().equals("Submission")) {
            if (this.loader != null) {
                this.loader.unregisterParameters();
            }
            this.loader = this.createLoader();
        }
    }

    protected void onContextDestroyed() {
        this.cancelHarvest();
    }
}

