/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.rest;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.events.GetConfigurationEvent;
import de.gerdiproject.harvest.config.json.ChangeConfigurationRequest;
import de.gerdiproject.harvest.config.json.adapters.ConfigurationAdapter;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.rest.AbstractRestResource;
import de.gerdiproject.harvest.rest.HttpResponseFactory;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="config")
public final class ConfigurationRestResource
extends AbstractRestResource<Configuration, GetConfigurationEvent> {
    public ConfigurationRestResource() {
        super(new GsonBuilder().registerTypeAdapter(Configuration.class, (Object)new ConfigurationAdapter()).create());
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Response setParameters(MultivaluedMap<String, String> formParams) {
        ChangeConfigurationRequest request = new ChangeConfigurationRequest();
        for (String key : formParams.keySet()) {
            request.put((Object)key, formParams.getFirst((Object)key));
        }
        return this.setConfiguration(this.gson.toJson((Object)request));
    }

    @Path(value="_set")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response setConfiguration(String configJson) {
        return this.changeObject(arg_0 -> ((Configuration)((Configuration)this.restObject)).setParameters(arg_0), configJson, ChangeConfigurationRequest.class);
    }

    public Response getInfoText(UriInfo uriInfo) {
        MultivaluedMap query = uriInfo.getQueryParameters();
        if (query.containsKey((Object)"key")) {
            if (this.restObject == null) {
                return HttpResponseFactory.createServerErrorResponse();
            }
            String compositeKey = (String)((List)query.get((Object)"key")).get(0);
            String value = ((Configuration)this.restObject).getParameterStringValue(compositeKey);
            if (value == null) {
                String errorMessage = String.format("Unknown parameter '%s'!", compositeKey);
                return HttpResponseFactory.createBadRequestResponse((String)errorMessage);
            }
            return HttpResponseFactory.createValueResponse((Response.Status)Response.Status.OK, (JsonElement)new JsonPrimitive(value));
        }
        return super.getInfoText(uriInfo);
    }

    protected String getAllowedRequests() {
        StringBuilder allowedValues = new StringBuilder();
        for (AbstractParameter param : ((Configuration)this.restObject).getParameters()) {
            if (allowedValues.length() != 0) {
                allowedValues.append(", ");
            }
            allowedValues.append(param.getCompositeKey());
        }
        return "GET\nRetrieves the configuration as a JSON object, or as plain text if the query parameter ?pretty is added.\n\nGET ?key=XXX\nReturns the value of parameter 'XXX'.\n\nPOST /_set {\"XXX.YYY\" : \"ZZZ\"}\nChanges the value of parameter YYY of category XXX to ZZZ.\n\nPUT\nSets x-www-form-urlencoded parameters for the harvester.\nValid keys: " + allowedValues.toString();
    }
}

