/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.parameters;

import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.constants.ParameterMappingFunctions;
import java.util.function.Function;

public class IntegerParameter
extends AbstractParameter<Integer> {
    public IntegerParameter(String key, String category, int defaultValue, Function<String, Integer> customMappingFunction) throws IllegalArgumentException {
        super(key, category, (Object)defaultValue, customMappingFunction);
    }

    public IntegerParameter(String key, String category, int defaultValue) {
        super(key, category, (Object)defaultValue, ParameterMappingFunctions::mapToInteger);
    }

    public IntegerParameter copy() {
        return new IntegerParameter(this.key, this.category, ((Integer)this.value).intValue(), this.mappingFunction);
    }

    public String getStringValue() {
        if ((Integer)this.value == Integer.MAX_VALUE) {
            return "max";
        }
        if ((Integer)this.value == Integer.MIN_VALUE) {
            return "min";
        }
        return String.valueOf(this.value);
    }
}

