/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.parameters;

import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameter<V> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractParameter.class);
    protected V value;
    protected final String key;
    protected final String category;
    protected Function<String, V> mappingFunction;
    private boolean isRegistered;

    public AbstractParameter(String key, String category, V defaultValue, Function<String, V> customMappingFunction) throws IllegalArgumentException {
        if (!key.matches("[a-zA-Z0-9]+")) {
            throw new IllegalArgumentException(String.format("Invalid Parameter-Key: %s%nKeys must only consist of letters!", key));
        }
        if (!category.matches("[a-zA-Z0-9]+")) {
            throw new IllegalArgumentException(String.format("Invalid Category-Name: %s%nNames must only consist of letters!", category));
        }
        this.key = key;
        this.category = category;
        this.value = defaultValue;
        this.mappingFunction = customMappingFunction;
    }

    public abstract AbstractParameter<V> copy();

    public String getKey() {
        return this.key;
    }

    public String getCompositeKey() {
        return String.format("%s.%s", this.category.toLowerCase(), this.key.toLowerCase());
    }

    public String getCategory() {
        return this.category;
    }

    public final V getValue() {
        return (V)this.value;
    }

    public String getStringValue() {
        return this.value != null ? this.value.toString() : "";
    }

    public Function<String, V> getMappingFunction() {
        return this.mappingFunction;
    }

    public void setMappingFunction(Function<String, V> mappingFunction) {
        this.mappingFunction = mappingFunction;
    }

    public final void setValue(String value) throws IllegalArgumentException {
        try {
            Object newValue = this.mappingFunction.apply(value);
            this.value = newValue;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Cannot change value of parameter '%s' to '%s'! %s", this.getCompositeKey(), value, e.getMessage()), e);
        }
    }

    public void loadFromEnvironmentVariables() {
        String envVarName = String.format("GERDI_HARVESTER_%S_%S", this.category, this.key);
        Map<String, String> environmentVariables = System.getenv();
        if (environmentVariables.containsKey(envVarName)) {
            this.setValue(environmentVariables.get(envVarName));
        }
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public String toString() {
        return this.getKey() + " : " + this.getStringValue();
    }
}

