/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.json.adapters;

import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.BooleanParameter;
import de.gerdiproject.harvest.config.parameters.IntegerParameter;
import de.gerdiproject.harvest.config.parameters.PasswordParameter;
import de.gerdiproject.harvest.config.parameters.StringParameter;

class ParameterJson {
    private final String key;
    private final String value;
    private final String type;

    public ParameterJson(AbstractParameter<?> parameter) {
        this.key = parameter.getKey();
        this.value = parameter.getValue() == null ? null : parameter.getValue().toString();
        this.type = parameter.getClass().getSimpleName();
    }

    public AbstractParameter<?> toAbstractParameter(String category) {
        BooleanParameter param = null;
        if (this.type.equals(BooleanParameter.class.getSimpleName())) {
            param = new BooleanParameter(this.key, category, Boolean.valueOf(this.value).booleanValue());
        } else if (this.type.equals(IntegerParameter.class.getSimpleName())) {
            param = new IntegerParameter(this.key, category, this.value == null ? 0 : Integer.parseInt(this.value));
        } else if (this.type.equals(StringParameter.class.getSimpleName())) {
            param = new StringParameter(this.key, category, this.value);
        } else if (this.type.equals(PasswordParameter.class.getSimpleName())) {
            param = new PasswordParameter(this.key, category, this.value);
        }
        return param;
    }
}

