/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.json.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.json.adapters.ParameterCategoryJson;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ConfigurationAdapter
implements JsonDeserializer<Configuration>,
JsonSerializer<Configuration> {
    private static final Type PARAM_MAP_TYPE = new /* Unavailable Anonymous Inner Class!! */.getType();

    public Configuration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Map jsonCategories = (Map)context.deserialize(json, PARAM_MAP_TYPE);
        LinkedList parameters = new LinkedList();
        jsonCategories.forEach((categoryName, jsonCat) -> parameters.addAll(jsonCat.getParameters(categoryName)));
        AbstractParameter[] parameterArray = new AbstractParameter[parameters.size()];
        parameters.toArray(parameterArray);
        return new Configuration(null, parameterArray);
    }

    public JsonElement serialize(Configuration src, Type typeOfSrc, JsonSerializationContext context) {
        HashMap<String, ParameterCategoryJson> jsonCategoriesMap = new HashMap<String, ParameterCategoryJson>();
        for (AbstractParameter param : src.getParameters()) {
            String categoryName = param.getCategory();
            ParameterCategoryJson category = (ParameterCategoryJson)jsonCategoriesMap.get(categoryName);
            if (category == null) {
                category = new ParameterCategoryJson();
                jsonCategoriesMap.put(categoryName, category);
            }
            category.addParameter(param);
        }
        return context.serialize(jsonCategoriesMap);
    }
}

