/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.application;

import de.gerdiproject.harvest.application.ContextListener;
import de.gerdiproject.harvest.application.events.ServiceInitializedEvent;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.etls.AbstractETL;
import de.gerdiproject.harvest.etls.ETLPreconditionException;
import de.gerdiproject.harvest.etls.events.GetRepositoryNameEvent;
import de.gerdiproject.harvest.etls.loaders.ILoader;
import de.gerdiproject.harvest.etls.loaders.utils.LoaderRegistry;
import de.gerdiproject.harvest.etls.utils.ETLManager;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEvent;
import de.gerdiproject.harvest.scheduler.Scheduler;
import de.gerdiproject.harvest.utils.CancelableFuture;
import de.gerdiproject.harvest.utils.logger.HarvesterLog;
import de.gerdiproject.harvest.utils.logger.events.GetMainLogEvent;
import de.gerdiproject.harvest.utils.maven.MavenUtils;
import de.gerdiproject.harvest.utils.maven.events.GetMavenUtilsEvent;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MainContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainContext.class);
    private static volatile MainContext instance = null;
    private static boolean hasFailed;
    private static boolean isInitialized;
    private final HarvesterLog log;
    private final String moduleName;
    private final ETLManager etlManager;
    private final Configuration configuration;
    private final LoaderRegistry loaderRegistry;
    private final Scheduler scheduler;
    private final MavenUtils mavenUtils;

    private MainContext(Class<? extends ContextListener> callerClass, Supplier<String> repositoryNameSupplier, Supplier<List<? extends AbstractETL<?, ?>>> etlSupplier, List<Class<? extends ILoader<?>>> loaderClasses) throws InstantiationException, IllegalAccessException {
        this.moduleName = repositoryNameSupplier.get().replaceAll(" ", "") + "HarvesterService";
        EventSystem.addSynchronousListener(GetRepositoryNameEvent.class, repositoryNameSupplier);
        this.log = this.createLog(this.moduleName);
        EventSystem.addSynchronousListener(GetMainLogEvent.class, () -> this.getMainLog());
        this.configuration = this.createConfiguration(this.moduleName);
        this.mavenUtils = this.createMavenUtils(callerClass);
        EventSystem.addSynchronousListener(GetMavenUtilsEvent.class, () -> this.getMavenUtils());
        this.loaderRegistry = this.createLoaderFactory(loaderClasses);
        this.etlManager = this.createEtlManager(this.moduleName, etlSupplier);
        this.scheduler = this.createScheduler(this.moduleName);
    }

    public static void init(Class<? extends ContextListener> callerClass, Supplier<String> repositoryNameSupplier, Supplier<List<? extends AbstractETL<?, ?>>> etlSupplier, List<Class<? extends ILoader<?>>> loaderClasses) {
        LOGGER.info("Initializing Harvester Service...");
        hasFailed = false;
        isInitialized = false;
        CancelableFuture initProcess = new CancelableFuture(() -> {
            MainContext.destroy();
            instance = new MainContext(callerClass, repositoryNameSupplier, etlSupplier, loaderClasses);
            return true;
        });
        initProcess.thenApply(MainContext::onHarvesterInitializedSuccess).exceptionally(MainContext::onHarvesterInitializedFailed);
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static boolean hasFailed() {
        return hasFailed;
    }

    public static void destroy() {
        if (instance != null) {
            instance.removeEventListeners();
            MainContext.instance.log.unregisterLogger();
            instance = null;
        }
        hasFailed = false;
        isInitialized = false;
    }

    private void removeEventListeners() {
        EventSystem.removeSynchronousListener(GetMainLogEvent.class);
        EventSystem.removeSynchronousListener(GetMavenUtilsEvent.class);
        this.scheduler.removeEventListeners();
        this.configuration.removeEventListeners();
        this.etlManager.removeEventListeners();
    }

    private HarvesterLog getMainLog() {
        return this.log;
    }

    private MavenUtils getMavenUtils() {
        return this.mavenUtils;
    }

    private LoaderRegistry createLoaderFactory(List<Class<? extends ILoader<?>>> loaderClasses) {
        LOGGER.info(String.format("Initializing %s...", LoaderRegistry.class.getSimpleName()));
        LoaderRegistry registry = new LoaderRegistry();
        registry.addEventListeners();
        for (Class<ILoader<?>> clazz : loaderClasses) {
            registry.registerLoader(clazz);
        }
        LOGGER.info(String.format("Successfully initialized %s!", LoaderRegistry.class.getSimpleName()));
        return registry;
    }

    private HarvesterLog createLog(String moduleName) {
        LOGGER.info(String.format("Initializing %s...", HarvesterLog.class.getSimpleName()));
        HarvesterLog serviceLog = new HarvesterLog(String.format("/var/log/harvester/%s.log", moduleName));
        serviceLog.registerLogger();
        LOGGER.info(String.format("Successfully initialized %s!", HarvesterLog.class.getSimpleName()));
        return serviceLog;
    }

    private MavenUtils createMavenUtils(Class<?> harvesterClass) {
        LOGGER.info(String.format("Initializing %s...", MavenUtils.class.getSimpleName()));
        MavenUtils utils = new MavenUtils(harvesterClass);
        LOGGER.info(String.format("Successfully initialized %s!", MavenUtils.class.getSimpleName()));
        return utils;
    }

    private ETLManager createEtlManager(String moduleName, Supplier<List<? extends AbstractETL<?, ?>>> etlSupplier) throws InstantiationException, IllegalAccessException {
        LOGGER.info(String.format("Initializing %s...", ETLManager.class.getSimpleName()));
        ETLManager manager = new ETLManager(moduleName);
        List<AbstractETL<?, ?>> etlComponents = etlSupplier.get();
        for (AbstractETL<?, ?> etl : etlComponents) {
            manager.register(etl);
            LOGGER.info(String.format("Initializing %s...", etl.getName()));
            etl.init(moduleName);
            try {
                etl.update();
            }
            catch (ETLPreconditionException eTLPreconditionException) {
                // empty catch block
            }
            LOGGER.info(String.format("Successfully initialized %s!", etl.getName()));
        }
        manager.loadFromDisk();
        manager.addEventListeners();
        LOGGER.info(String.format("Successfully initialized %s!", ETLManager.class.getSimpleName()));
        return manager;
    }

    private Scheduler createScheduler(String moduleName) {
        LOGGER.info(String.format("Initializing %s...", Scheduler.class.getSimpleName()));
        String schedulerCachePath = String.format("cache/%s/schedule.json", moduleName);
        Scheduler sched = new Scheduler(moduleName, schedulerCachePath);
        sched.loadFromDisk();
        sched.addEventListeners();
        LOGGER.info(String.format("Successfully initialized %s!", Scheduler.class.getSimpleName()));
        return sched;
    }

    private Configuration createConfiguration(String moduleName) {
        LOGGER.info(String.format("Initializing %s...", Configuration.class.getSimpleName()));
        Configuration config = new Configuration(moduleName, new AbstractParameter[0]);
        config.setCacheFilePath(String.format("cache/%s/config.json", moduleName));
        config.loadFromDisk();
        config.addEventListeners();
        LOGGER.info(String.format("Successfully initialized %s!", Configuration.class.getSimpleName()));
        return config;
    }

    private static Boolean onHarvesterInitializedSuccess(Boolean state) {
        hasFailed = false;
        isInitialized = true;
        EventSystem.sendEvent((IEvent)new ServiceInitializedEvent(state.booleanValue()));
        LOGGER.info(String.format("%s is now ready!", MainContext.instance.moduleName));
        return state;
    }

    private static Boolean onHarvesterInitializedFailed(Throwable reason) {
        hasFailed = true;
        isInitialized = true;
        LOGGER.error("Initialization of the Harvester Service failed!", reason.getCause());
        EventSystem.sendEvent((IEvent)new ServiceInitializedEvent(false));
        return false;
    }
}

