/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.event;

import de.gerdiproject.event.examples.TestEvent;
import de.gerdiproject.event.examples.TestSynchronousEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEvent;
import de.gerdiproject.harvest.event.ISynchronousEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventSystemTest {
    private static final List<TestEvent> TEST_EVENTS = Arrays.asList(new TestEvent((Object)"uno"), new TestEvent((Object)"dos"), new TestEvent((Object)"tres"));
    private static final TestEvent SINGLE_TEST_EVENT = new TestEvent((Object)"single");
    private static final TestSynchronousEvent SINGLE_SYNC_TEST_EVENT = new TestSynchronousEvent((Object)"single");
    private static final String STATIC_SYNC_PAYLOAD = "123";
    private static final String REMOVE_LISTENER_ERROR = "Removing non-existing listeners should not cause exceptions";
    private List<TestEvent> receivedEvents;
    private final Consumer<TestEvent> onTestEvent = event -> this.receivedEvents.add(event);
    private final Consumer<TestEvent> onTestEvent2 = event -> this.receivedEvents.add(event);
    private final Function<TestSynchronousEvent, Object> onTestSyncEvent = event -> event.getPayload();
    private final Function<TestSynchronousEvent, Object> onTestSyncEvent2 = event -> "123";

    @Before
    public void before() {
        this.receivedEvents = new LinkedList();
    }

    @After
    public void after() {
        EventSystem.removeAllListeners(TestEvent.class);
        EventSystem.removeSynchronousListener(TestSynchronousEvent.class);
    }

    @Test
    public void testSendingEventsWithoutAddedListener() {
        TestEvent ignoredEvent = (TestEvent)TEST_EVENTS.get(0);
        EventSystem.sendEvent((IEvent)ignoredEvent);
        Assert.assertFalse((String)("A callback function of " + ignoredEvent.getClass().getSimpleName() + " was called although no listener was added!"), (boolean)this.receivedEvents.contains(ignoredEvent));
    }

    @Test
    public void testSendingEventsWithAddedListener() {
        TestEvent expectedEvent = (TestEvent)TEST_EVENTS.get(1);
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.sendEvent((IEvent)expectedEvent);
        Assert.assertTrue((String)("The callback function of " + expectedEvent.getClass().getSimpleName() + " was never called although a listener was added!"), (boolean)this.receivedEvents.contains(expectedEvent));
    }

    @Test
    public void testAddingListenerTwice() {
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.sendEvent((IEvent)SINGLE_TEST_EVENT);
        Assert.assertEquals((String)("The same callback function was assigned to " + TestEvent.class.getSimpleName() + " twice, so sending the event once, should cause the callback function to be called twice!"), (long)2L, (long)this.receivedEvents.size());
    }

    @Test
    public void testRemovingListener() {
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.removeListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.sendEvent((IEvent)SINGLE_TEST_EVENT);
        Assert.assertEquals((String)"The method removeListener() should have caused the event listener to be removed!", (long)0L, (long)this.receivedEvents.size());
    }

    @Test
    public void testRemovingNonExistingListener() {
        try {
            EventSystem.removeListener(TestEvent.class, (Consumer)this.onTestEvent);
        }
        catch (Exception e) {
            Assert.fail((String)REMOVE_LISTENER_ERROR);
        }
    }

    @Test
    public void testRemovingAllListeners() {
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.removeAllListeners(TestEvent.class);
        EventSystem.sendEvent((IEvent)SINGLE_TEST_EVENT);
        Assert.assertEquals((String)("The method removeAllListeners() should have removed all listeners of " + TestEvent.class.getSimpleName() + "!"), (long)0L, (long)this.receivedEvents.size());
    }

    @Test
    public void testRemovingAllListenersNonExisting() {
        try {
            EventSystem.removeAllListeners(TestEvent.class);
        }
        catch (Exception e) {
            Assert.fail((String)REMOVE_LISTENER_ERROR);
        }
    }

    @Test
    public void testSendingSynchronousEventWithoutAddedListener() {
        Object nullResult = EventSystem.sendSynchronousEvent((ISynchronousEvent)SINGLE_SYNC_TEST_EVENT);
        Assert.assertNull((String)"The method sendSynchronousEvent() should return null if it was not assigned via addSynchronousListener()!", (Object)nullResult);
    }

    @Test
    public void testSendingSynchronousEventWithAddedListener() {
        EventSystem.addSynchronousListener(TestSynchronousEvent.class, (Function)this.onTestSyncEvent);
        Object result = EventSystem.sendSynchronousEvent((ISynchronousEvent)SINGLE_SYNC_TEST_EVENT);
        Assert.assertEquals((String)"The method sendSynchronousEvent() did not return the value that was defined in its callback function!", (Object)SINGLE_SYNC_TEST_EVENT.getPayload(), (Object)result);
    }

    @Test
    public void testAddingSynchronousListenerOverride() {
        EventSystem.addSynchronousListener(TestSynchronousEvent.class, (Function)this.onTestSyncEvent);
        Object oldResult = EventSystem.sendSynchronousEvent((ISynchronousEvent)SINGLE_SYNC_TEST_EVENT);
        EventSystem.addSynchronousListener(TestSynchronousEvent.class, (Function)this.onTestSyncEvent2);
        Object overriddenResult = EventSystem.sendSynchronousEvent((ISynchronousEvent)SINGLE_SYNC_TEST_EVENT);
        Assert.assertNotEquals((String)"The method addSynchronousListener() should overwrite an already assigned callback function!", (Object)oldResult, (Object)overriddenResult);
    }

    @Test
    public void testSendingSynchronousEventWithoutEventArgument() {
        EventSystem.addSynchronousListener(TestSynchronousEvent.class, () -> STATIC_SYNC_PAYLOAD);
        Object result = EventSystem.sendSynchronousEvent((ISynchronousEvent)SINGLE_SYNC_TEST_EVENT);
        Assert.assertEquals((String)"The method sendSynchronousEvent() should return the expected payload after addSynchronousListener() was called with a Supplier as argument!", (Object)STATIC_SYNC_PAYLOAD, (Object)result);
    }

    @Test
    public void testRemovingSynchronousListener() {
        EventSystem.addSynchronousListener(TestSynchronousEvent.class, (Function)this.onTestSyncEvent);
        EventSystem.removeSynchronousListener(TestSynchronousEvent.class);
        Object nullResult = EventSystem.sendSynchronousEvent((ISynchronousEvent)SINGLE_SYNC_TEST_EVENT);
        Assert.assertNull((String)"The method sendSynchronousEvent() should return null after removeSynchronousListener() was called!", (Object)nullResult);
    }

    @Test
    public void testRemovingNonExistingSynchronousListener() {
        try {
            EventSystem.removeSynchronousListener(TestSynchronousEvent.class);
        }
        catch (Exception e) {
            Assert.fail((String)REMOVE_LISTENER_ERROR);
        }
    }

    @Test
    public void testSendingEventsAfterReset() {
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent2);
        EventSystem.reset();
        EventSystem.sendEvent((IEvent)SINGLE_TEST_EVENT);
        Assert.assertEquals((String)"The method reset() should remove all asynchronous callback functions!", (long)0L, (long)this.receivedEvents.size());
    }

    @Test
    public void testSendingSynchronousEventsAfterReset() {
        EventSystem.addSynchronousListener(TestSynchronousEvent.class, (Function)this.onTestSyncEvent);
        EventSystem.reset();
        Object nullResult = EventSystem.sendSynchronousEvent((ISynchronousEvent)SINGLE_SYNC_TEST_EVENT);
        Assert.assertNull((String)"The method reset() should remove all synchronous callback functions!", (Object)nullResult);
    }

    @Test
    public void testResetNonExisting() {
        try {
            EventSystem.reset();
        }
        catch (Exception e) {
            Assert.fail((String)REMOVE_LISTENER_ERROR);
        }
    }

    @Test
    public void testEventOrder() {
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        for (TestEvent event : TEST_EVENTS) {
            EventSystem.sendEvent((IEvent)event);
        }
        for (int i = 0; i < TEST_EVENTS.size(); ++i) {
            Assert.assertEquals((String)"Callback functions must be executed in the same order in which the events were dispatched!", TEST_EVENTS.get(i), this.receivedEvents.get(i));
        }
    }

    @Test
    public void testEmptyEventListeners() {
        Assert.assertFalse((String)"The method hasAsynchronousEventListeners() should return false if addListener() was never called!", (boolean)EventSystem.hasAsynchronousEventListeners());
    }

    @Test
    public void testEmptySynchronousEventListeners() {
        Assert.assertFalse((String)"The method hasSynchronousEventListeners() should return false if addSynchronousListener() was never called!", (boolean)EventSystem.hasSynchronousEventListeners());
    }

    @Test
    public void testNonEmptyEventListeners() {
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        Assert.assertTrue((String)"The method hasAsynchronousEventListeners() should return true if addListener() was called!", (boolean)EventSystem.hasAsynchronousEventListeners());
    }

    @Test
    public void testNonEmptySynchronousEventListeners() {
        EventSystem.addSynchronousListener(TestSynchronousEvent.class, (Function)this.onTestSyncEvent);
        Assert.assertTrue((String)"The method hasSynchronousEventListeners() should return true if addSynchronousListener() was called!", (boolean)EventSystem.hasSynchronousEventListeners());
    }

    @Test
    public void testEmptyEventListenersAfterRemoval() {
        EventSystem.addListener(TestEvent.class, (Consumer)this.onTestEvent);
        EventSystem.removeListener(TestEvent.class, (Consumer)this.onTestEvent);
        Assert.assertFalse((String)"The method hasAsynchronousEventListeners() should return false after all asynchronous listeners were removed!", (boolean)EventSystem.hasAsynchronousEventListeners());
    }

    @Test
    public void testEmptySynchronousEventListenersAfterRemoval() {
        EventSystem.addSynchronousListener(TestSynchronousEvent.class, (Function)this.onTestSyncEvent);
        EventSystem.removeSynchronousListener(TestSynchronousEvent.class);
        Assert.assertFalse((String)"The method hasSynchronousEventListeners() should return false after all synchronous listeners were removed!", (boolean)EventSystem.hasSynchronousEventListeners());
    }
}

