/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.application;

import de.gerdiproject.AbstractObjectUnitTest;
import de.gerdiproject.application.examples.MockedContextListener;
import de.gerdiproject.harvest.application.ContextListener;
import de.gerdiproject.harvest.application.events.ContextDestroyedEvent;
import de.gerdiproject.harvest.application.events.ServiceInitializedEvent;
import de.gerdiproject.harvest.utils.file.FileUtils;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class ContextListenerTest
extends AbstractObjectUnitTest<ContextListener> {
    private static final int INIT_TIMEOUT = 5000;
    private static final File CACHE_FOLDER = new File("cache");
    private static final String CLEANUP_ERROR = "Could not delete temporary test directory for MainContext tests: " + CACHE_FOLDER;

    public void before() throws InstantiationException {
        FileUtils.deleteFile((File)CACHE_FOLDER);
        if (CACHE_FOLDER.exists()) {
            throw new InstantiationException(CLEANUP_ERROR);
        }
        super.before();
    }

    public void after() {
        super.after();
        FileUtils.deleteFile((File)CACHE_FOLDER);
    }

    protected MockedContextListener setUpTestObjects() {
        return new MockedContextListener();
    }

    @Test
    public void testServiceDeployment() {
        ServiceInitializedEvent initializationDoneEvent = (ServiceInitializedEvent)this.waitForEvent(ServiceInitializedEvent.class, 5000, () -> ((ContextListener)this.testedObject).contextInitialized(null));
        Assert.assertTrue((String)"The contextInitialized() callback method should trigger a successful MainContext initialization!", (boolean)initializationDoneEvent.isSuccessful());
    }

    @Test
    public void testServiceUndeployment() {
        this.waitForEvent(ServiceInitializedEvent.class, 5000, () -> ((ContextListener)this.testedObject).contextInitialized(null));
        System.out.print("This following message is part of Unit Testing: ");
        ContextDestroyedEvent destroyedEvent = (ContextDestroyedEvent)this.waitForEvent(ContextDestroyedEvent.class, 2000, () -> ((ContextListener)this.testedObject).contextDestroyed(null));
        Assert.assertNotNull((String)"The method contextInitialized() should throw an event!", (Object)destroyedEvent);
    }

    @Test
    public void testServiceName() {
        Assert.assertNotNull((String)"The method getServiceName() should return a proper string!", (Object)((MockedContextListener)this.testedObject).getServiceName());
    }

    @Test
    public void testSubmitterClasses() {
        Assert.assertFalse((String)"The method getSubmitterClasses() is supposed to return a non-empty list of classe!", (boolean)((MockedContextListener)this.testedObject).getLoaderClasses().isEmpty());
    }
}

