/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject;

import de.gerdiproject.AbstractUnitTest;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEventListener;
import java.lang.reflect.ParameterizedType;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class AbstractObjectUnitTest<T>
extends AbstractUnitTest {
    private static final String SKIP_EVENT_TESTS_MESSAGE = "Skipping event listener tests, because %s does not implement " + IEventListener.class.getSimpleName() + ".";
    protected static final String INSTANTIATION_ERROR = "Could not instantiate object: ";
    protected Configuration config;
    protected T testedObject;

    public void before() throws InstantiationException {
        super.before();
        this.testedObject = this.setUpTestObjects();
        if (this.testedObject == null) {
            throw new InstantiationException(INSTANTIATION_ERROR + this.getTestedClass().getName());
        }
    }

    public void after() {
        super.after();
        this.testedObject = null;
    }

    @Test
    public void testAddingEventListeners() {
        Assume.assumeTrue((String)String.format(SKIP_EVENT_TESTS_MESSAGE, this.testedObject.getClass().getSimpleName()), (boolean)(this.testedObject instanceof IEventListener));
        if (this.config != null) {
            this.config.removeEventListeners();
        }
        ((IEventListener)this.testedObject).addEventListeners();
        Assert.assertTrue((String)"The method addEventListeners() is not adding any event listeners!", (EventSystem.hasSynchronousEventListeners() || EventSystem.hasAsynchronousEventListeners() ? 1 : 0) != 0);
    }

    @Test
    public void testForNoInitialEventListeners() {
        Assume.assumeTrue((String)String.format(SKIP_EVENT_TESTS_MESSAGE, this.testedObject.getClass().getSimpleName()), (boolean)(this.testedObject instanceof IEventListener));
        if (this.config != null) {
            this.config.removeEventListeners();
        }
        Assert.assertFalse((String)"Event listeners should not be added in the constructor!", (EventSystem.hasSynchronousEventListeners() || EventSystem.hasAsynchronousEventListeners() ? 1 : 0) != 0);
    }

    @Test
    public void testRemovingEventListeners() {
        Assume.assumeTrue((String)String.format(SKIP_EVENT_TESTS_MESSAGE, this.testedObject.getClass().getSimpleName()), (boolean)(this.testedObject instanceof IEventListener));
        if (this.config != null) {
            this.config.removeEventListeners();
        }
        ((IEventListener)this.testedObject).addEventListeners();
        ((IEventListener)this.testedObject).removeEventListeners();
        Assert.assertFalse((String)"The method removeEventListeners() should remove all listeners!", (EventSystem.hasSynchronousEventListeners() || EventSystem.hasAsynchronousEventListeners() ? 1 : 0) != 0);
    }

    protected abstract T setUpTestObjects();

    protected Class<T> getTestedClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

