/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.time;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.events.HarvestFinishedEvent;
import de.gerdiproject.harvest.harvester.events.HarvestStartedEvent;
import de.gerdiproject.harvest.save.events.SaveFinishedEvent;
import de.gerdiproject.harvest.save.events.SaveStartedEvent;
import de.gerdiproject.harvest.submission.events.SubmissionFinishedEvent;
import de.gerdiproject.harvest.submission.events.SubmissionStartedEvent;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.harvest.utils.time.ProcessTimeMeasure;
import de.gerdiproject.harvest.utils.time.events.ProcessTimeMeasureFinishedEvent;

public class HarvestTimeKeeper {
    private final ProcessTimeMeasure harvestMeasure = new ProcessTimeMeasure();
    private final ProcessTimeMeasure submissionMeasure;
    private final ProcessTimeMeasure saveMeasure = new ProcessTimeMeasure();

    public HarvestTimeKeeper() {
        this.submissionMeasure = new ProcessTimeMeasure();
    }

    public void init() {
        this.loadFromDisk();
        this.harvestMeasure.init(HarvestStartedEvent.class, HarvestFinishedEvent.class);
        this.saveMeasure.init(SaveStartedEvent.class, SaveFinishedEvent.class);
        this.submissionMeasure.init(SubmissionStartedEvent.class, SubmissionFinishedEvent.class);
        EventSystem.addListener(HarvestStartedEvent.class, this::onHarvestStarted);
        EventSystem.addListener(ProcessTimeMeasureFinishedEvent.class, this::onProcessTimeMeasureFinished);
    }

    private void loadFromDisk() {
        DiskIO diskReader = new DiskIO();
        String stableFilePath = String.format("cache/%s/processTimes.json", MainContext.getModuleName());
        HarvestTimeKeeper parsedKeeper = diskReader.getObject(stableFilePath, HarvestTimeKeeper.class);
        if (parsedKeeper != null) {
            if (parsedKeeper.harvestMeasure.getStatus() != ProcessTimeMeasure.ProcessStatus.Started) {
                this.harvestMeasure.set(parsedKeeper.harvestMeasure);
            }
            if (parsedKeeper.saveMeasure.getStatus() != ProcessTimeMeasure.ProcessStatus.Started) {
                this.saveMeasure.set(parsedKeeper.saveMeasure);
            }
            if (parsedKeeper.submissionMeasure.getStatus() != ProcessTimeMeasure.ProcessStatus.Started) {
                this.submissionMeasure.set(parsedKeeper.submissionMeasure);
            }
        }
    }

    public ProcessTimeMeasure getHarvestMeasure() {
        return this.harvestMeasure;
    }

    public ProcessTimeMeasure getSubmissionMeasure() {
        return this.submissionMeasure;
    }

    public ProcessTimeMeasure getSaveMeasure() {
        return this.saveMeasure;
    }

    public boolean isHarvestIncomplete() {
        return this.harvestMeasure.getStatus() == ProcessTimeMeasure.ProcessStatus.Failed || this.harvestMeasure.getStatus() == ProcessTimeMeasure.ProcessStatus.Aborted;
    }

    public boolean hasUnsubmittedChanges() {
        return this.harvestMeasure.getStatus() != ProcessTimeMeasure.ProcessStatus.NotStarted && this.submissionMeasure.getStatus() != ProcessTimeMeasure.ProcessStatus.Finished;
    }

    private void saveToDisk() {
        String stableFilePath = String.format("cache/%s/processTimes.json", MainContext.getModuleName());
        DiskIO diskWriter = new DiskIO();
        diskWriter.writeObjectToFile(stableFilePath, (Object)this);
    }

    private void onHarvestStarted(HarvestStartedEvent event) {
        this.saveMeasure.set(-1L, -1L, ProcessTimeMeasure.ProcessStatus.NotStarted);
        this.submissionMeasure.set(-1L, -1L, ProcessTimeMeasure.ProcessStatus.NotStarted);
    }

    private void onProcessTimeMeasureFinished(ProcessTimeMeasureFinishedEvent event) {
        this.saveToDisk();
    }
}

