/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.logger;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.utils.logger.constants.LoggerConstants;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(LoggerUtils.class);

    private LoggerUtils() {
    }

    public static String getLog(List<String> dateFilters, List<String> levelFilters, List<String> classFilters) {
        StringBuilder logBuilder = new StringBuilder();
        String logFilePath = String.format("/var/log/harvester/%s.log", MainContext.getModuleName());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFilePath), MainContext.getCharset()));){
            if (dateFilters == null && levelFilters == null && classFilters == null) {
                logBuilder.append(reader.lines().collect(Collectors.joining("\n")));
            } else {
                String line;
                boolean shouldAddLine = false;
                while ((line = reader.readLine()) != null) {
                    Matcher lineMatch = LoggerConstants.PARSE_LOG_PATTERN.matcher(line);
                    if (lineMatch.matches()) {
                        boolean bl = shouldAddLine = !(dateFilters != null && !dateFilters.contains(lineMatch.group(1)) || classFilters != null && !classFilters.contains(lineMatch.group(2)) || levelFilters != null && !levelFilters.contains(lineMatch.group(3)));
                    }
                    if (!shouldAddLine) continue;
                    logBuilder.append(line).append('\n');
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not read log file: %s", logFilePath), (Throwable)e);
            return null;
        }
        return logBuilder.toString();
    }

    public static void init(String logFileName) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        FileAppender fileAppender = new FileAppender();
        fileAppender.setContext((Context)loggerContext);
        fileAppender.setFile(String.format("/var/log/harvester/%s.log", logFileName));
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        encoder.setPattern("%date %logger{0} %level %msg%n");
        encoder.start();
        fileAppender.setEncoder((Encoder)encoder);
        fileAppender.start();
        LoggerConstants.ROOT_LOGGER.addAppender((Appender)fileAppender);
    }
}

