/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.data;

import com.google.gson.JsonObject;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.config.events.GlobalParameterChangedEvent;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.utils.data.DiskIO;
import de.gerdiproject.harvest.utils.data.WebDataRetriever;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.ws.http.HTTPException;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequester {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequester.class);
    public boolean suppressWarnings;
    private final Charset httpCharset;
    private final DiskIO diskIO;
    private final WebDataRetriever webDataRetriever;
    private boolean readFromDisk;
    private boolean writeToDisk;
    private Consumer<GlobalParameterChangedEvent> onGlobalParameterChanged = event -> {
        AbstractParameter<?> param = event.getParameter();
        if (param.getKey().equals("readFromDisk")) {
            this.readFromDisk = (Boolean)param.getValue();
        }
        if (param.getKey().equals("writeToDisk")) {
            this.writeToDisk = (Boolean)param.getValue();
        }
    };

    public HttpRequester() {
        this(MainContext.getCharset(), false);
    }

    public HttpRequester(Charset httpCharset, boolean suppressWarnings) {
        Configuration config = MainContext.getConfiguration();
        if (config != null) {
            this.readFromDisk = config.getParameterValue("readFromDisk", Boolean.class);
            this.writeToDisk = config.getParameterValue("writeToDisk", Boolean.class);
        }
        this.httpCharset = httpCharset;
        this.suppressWarnings = suppressWarnings;
        this.diskIO = new DiskIO();
        this.webDataRetriever = new WebDataRetriever();
        EventSystem.addListener(GlobalParameterChangedEvent.class, this.onGlobalParameterChanged);
    }

    public JsonObject getJsonFromUrl(String url) {
        JsonObject jsonObj = null;
        boolean isResponseReadFromWeb = false;
        if (this.readFromDisk) {
            String filePath = this.urlToFilePath(url, "json");
            jsonObj = (JsonObject)this.diskIO.getJson(filePath);
        }
        if (jsonObj == null) {
            jsonObj = (JsonObject)this.webDataRetriever.getJson(url);
            isResponseReadFromWeb = true;
        }
        if (isResponseReadFromWeb && this.writeToDisk) {
            this.diskIO.writeObjectToFile(this.urlToFilePath(url, "json"), (Object)jsonObj);
        }
        if (jsonObj != null && jsonObj.size() > 0) {
            return jsonObj;
        }
        return null;
    }

    public Document getHtmlFromUrl(String url) {
        Document htmlResponse = null;
        boolean isResponseReadFromWeb = false;
        if (this.readFromDisk) {
            htmlResponse = this.diskIO.getHtml(this.urlToFilePath(url, "html"));
        }
        if (htmlResponse == null) {
            htmlResponse = this.webDataRetriever.getHtml(url);
            isResponseReadFromWeb = true;
        }
        if (isResponseReadFromWeb && this.writeToDisk) {
            String responseText = htmlResponse == null ? "" : htmlResponse.toString();
            this.diskIO.writeStringToFile(this.urlToFilePath(url, "html"), responseText);
        }
        return htmlResponse;
    }

    public <T> T getObjectFromUrl(String url, Class<T> targetClass) {
        T targetObject = null;
        boolean isResponseReadFromWeb = false;
        if (this.readFromDisk) {
            targetObject = this.diskIO.getObject(this.urlToFilePath(url, "json"), targetClass);
        }
        if (targetObject == null) {
            targetObject = this.webDataRetriever.getObject(url, targetClass);
            isResponseReadFromWeb = true;
        }
        if (isResponseReadFromWeb && this.writeToDisk) {
            this.diskIO.writeObjectToFile(this.urlToFilePath(url, "json"), targetObject);
        }
        return targetObject;
    }

    public <T> T getObjectFromUrl(String url, Type targetType) {
        T targetObject = null;
        boolean isResponseReadFromWeb = false;
        if (this.readFromDisk) {
            targetObject = this.diskIO.getObject(this.urlToFilePath(url, "json"), targetType);
        }
        if (targetObject == null) {
            targetObject = this.webDataRetriever.getObject(url, targetType);
            isResponseReadFromWeb = true;
        }
        if (isResponseReadFromWeb && this.writeToDisk) {
            this.diskIO.writeObjectToFile(this.urlToFilePath(url, "json"), targetObject);
        }
        return targetObject;
    }

    private String urlToFilePath(String url, String fileEnding) {
        String path = url;
        int schemeEnd = path.indexOf("://");
        schemeEnd = schemeEnd != -1 ? schemeEnd + 3 : 0;
        path = path.substring(schemeEnd);
        path = path.replace("//", "/");
        path = path.replace(":", "%colon%");
        path = path.replace("?", "%query%/");
        if ((path = path.replace("*", "%star%")).charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        return String.format("savedHttpResponses/%s/%sresponse.%s", MainContext.getModuleName(), path, fileEnding);
    }

    public String getRestResponse(RestRequestType method, String url, String body) throws HTTPException, IOException {
        return this.getRestResponse(method, url, body, null, "text/plain");
    }

    public String getRestResponse(RestRequestType method, String url, String body, String authorization, String contentType) throws HTTPException, IOException {
        HttpURLConnection connection = this.sendRestRequest(method, url, body, authorization, contentType);
        InputStream response = connection.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(response, this.httpCharset));
        String line = reader.readLine();
        String responseText = null;
        if (line != null) {
            StringBuilder responseBuilder = new StringBuilder(line);
            line = reader.readLine();
            while (line != null) {
                responseBuilder.append('\n').append(line);
                line = reader.readLine();
            }
            responseText = responseBuilder.toString();
        }
        reader.close();
        return responseText;
    }

    public Map<String, List<String>> getRestHeader(RestRequestType method, String url, String body) throws HTTPException, IOException {
        return this.getRestHeader(method, url, body, null, "text/plain");
    }

    public Map<String, List<String>> getRestHeader(RestRequestType method, String url, String body, String authorization, String contentType) throws HTTPException, IOException {
        Map<String, List<String>> headerFields = null;
        HttpURLConnection connection = this.sendRestRequest(method, url, body, authorization, contentType);
        headerFields = connection.getHeaderFields();
        return headerFields;
    }

    private HttpURLConnection sendRestRequest(RestRequestType method, String url, String body, String authorization, String contentType) throws IOException, HTTPException {
        int responseCode;
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setUseCaches(false);
        connection.setRequestMethod(method.toString());
        connection.setRequestProperty("Content-Type", contentType);
        connection.setRequestProperty("charset", this.httpCharset.displayName());
        if (authorization != null) {
            connection.setRequestProperty("Authorization", authorization);
        }
        if (body != null) {
            byte[] bodyBytes = body.getBytes(this.httpCharset);
            connection.setRequestProperty("Content-Length", Integer.toString(bodyBytes.length));
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.write(bodyBytes);
            wr.close();
        }
        if ((responseCode = connection.getResponseCode()) < 200 || responseCode >= 300) {
            if (!this.suppressWarnings) {
                LOGGER.warn(String.format("%s-request for URL '%s' with body '%s' returned HTTP Status-Code %d.", method.toString(), url, body, responseCode));
            }
            throw new HTTPException(connection.getResponseCode());
        }
        return connection;
    }

    public static enum RestRequestType {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        OPTIONS;

    }
}

