/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.cache;

import de.gerdiproject.harvest.utils.cache.HarvesterCache;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class HarvesterCacheManager {
    private static HarvesterCacheManager instance = new HarvesterCacheManager();
    private final List<HarvesterCache> cacheList = Collections.synchronizedList(new LinkedList());

    private HarvesterCacheManager() {
    }

    public static HarvesterCacheManager instance() {
        return instance;
    }

    public void registerCache(HarvesterCache cache) {
        this.cacheList.add(cache);
    }

    public List<HarvesterCache> getHarvesterCaches() {
        return Collections.unmodifiableList(this.cacheList);
    }

    public void reset() {
        this.cacheList.clear();
    }

    public int getNumberOfHarvestedDocuments() {
        int harvestedCount = 0;
        for (HarvesterCache cache : this.cacheList) {
            harvestedCount += cache.getChangesCache().size();
        }
        return harvestedCount;
    }
}

