/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.cache;

import com.google.gson.stream.JsonReader;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.utils.cache.AbstractCache;
import de.gerdiproject.harvest.utils.cache.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class DocumentVersionsCache
extends AbstractCache<String> {
    public DocumentVersionsCache(String harvesterName) {
        super(String.format("cache/%s/documents/%s/versions", MainContext.getModuleName(), harvesterName), String.format("cache/%s/documents_temp/%s/versions", MainContext.getModuleName(), harvesterName), String.class);
    }

    public void init(String hash) {
        File wipSourceHash = new File(String.format("%s/sourceHash.json", this.wipFolderPath));
        FileUtils.deleteFile(wipSourceHash);
        if (hash != null) {
            this.diskIo.writeStringToFile(wipSourceHash, hash);
        }
    }

    public boolean isOutdated() {
        String stableHarvesterHash = this.diskIo.getString(String.format("%s/sourceHash.json", this.stableFolderPath));
        if (stableHarvesterHash == null) {
            return true;
        }
        String wipHarvesterHash = this.diskIo.getString(String.format("%s/sourceHash.json", this.wipFolderPath));
        return !stableHarvesterHash.equals(wipHarvesterHash);
    }

    @Override
    public void applyChanges() {
        FileUtils.integrateDirectory(new File(this.wipFolderPath), new File(this.stableFolderPath), true);
    }

    @Override
    @Deprecated
    protected void migrateToNewSystem() {
        String harvesterName = new File(this.stableFolderPath).getParentFile().getName();
        File stableFile = new File(String.format("cache/%s/%s_documentVersions.json", MainContext.getModuleName(), harvesterName));
        if (stableFile.exists()) {
            try (JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(stableFile), MainContext.getCharset()));){
                reader.beginObject();
                reader.nextName();
                String sourceHash = reader.nextString();
                File stableHarvesterHash = new File(String.format("%s/sourceHash.json", this.stableFolderPath));
                this.diskIo.writeStringToFile(stableHarvesterHash, sourceHash);
                reader.nextName();
                reader.beginObject();
                while (reader.hasNext()) {
                    String documentId = reader.nextName();
                    String documentHash = reader.nextString();
                    this.diskIo.writeObjectToFile(this.getFile(documentId, true), (Object)documentHash);
                }
            }
            catch (IOException e) {
                return;
            }
            FileUtils.deleteFile(stableFile);
        }
    }
}

