/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils;

import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.ISynchronousEvent;
import de.gerdiproject.harvest.state.IState;
import de.gerdiproject.harvest.state.StateMachine;
import de.gerdiproject.harvest.state.impl.ErrorState;
import de.gerdiproject.harvest.state.impl.InitializationState;
import javax.ws.rs.core.Response;

public class ServerResponseFactory {
    private ServerResponseFactory() {
    }

    public static Response createInitResponse() {
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Cannot process request: Please wait for the harvester to be initialized!").type("text/plain").build();
    }

    public static Response createBusyResponse(String message, long retryInSeconds) {
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)message).type("text/plain");
        if (retryInSeconds != -1L) {
            rb.header("Retry-After", (Object)retryInSeconds);
        }
        return rb.build();
    }

    public static Response createAcceptedResponse(String message) {
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)message).type("text/plain").build();
    }

    public static Response createFubarResponse() {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Cannot process request, because the Harvester could not be initialized! Look at the logs for details.").type("text/plain").build();
    }

    public static Response createUnknownErrorResponse() {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Cannot process request due to an unknown error!").type("text/plain").build();
    }

    public static Response createBadRequestResponse() {
        return ServerResponseFactory.createBadRequestResponse("N/A");
    }

    public static Response createBadRequestResponse(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).type("text/plain").build();
    }

    public static Response createOkResponse(Object entity) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)(entity == null ? "" : entity.toString())).type("text/plain").build();
    }

    public static Response createResponse(Response.Status status, Object entity) {
        return Response.status((Response.Status)status).entity((Object)(entity == null ? "" : entity.toString())).type("text/plain").build();
    }

    public static Response createServerErrorResponse() {
        IState currentState = StateMachine.getCurrentState();
        if (currentState instanceof InitializationState) {
            return ServerResponseFactory.createInitResponse();
        }
        if (currentState instanceof ErrorState) {
            return ServerResponseFactory.createFubarResponse();
        }
        return ServerResponseFactory.createUnknownErrorResponse();
    }

    public static Response createSynchronousEventResponse(ISynchronousEvent<?> event) {
        Object eventResponse = EventSystem.sendSynchronousEvent(event);
        if (eventResponse == null) {
            return ServerResponseFactory.createServerErrorResponse();
        }
        if (eventResponse instanceof Response) {
            return (Response)eventResponse;
        }
        return ServerResponseFactory.createOkResponse(eventResponse);
    }
}

