/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.submission.elasticsearch;

import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.config.events.GlobalParameterChangedEvent;
import de.gerdiproject.harvest.submission.AbstractSubmitter;
import de.gerdiproject.harvest.submission.elasticsearch.json.ElasticSearchIndex;
import de.gerdiproject.harvest.submission.elasticsearch.json.ElasticSearchIndexWrapper;
import de.gerdiproject.harvest.submission.elasticsearch.json.ElasticSearchResponse;
import de.gerdiproject.harvest.utils.data.HttpRequester;
import de.gerdiproject.json.GsonUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.ServerException;
import java.util.List;
import java.util.Map;

public class ElasticSearchSubmitter
extends AbstractSubmitter {
    private HttpRequester httpRequester;

    @Override
    public void init() {
        super.init();
        this.httpRequester = new HttpRequester();
    }

    @Override
    protected void submitBatch(Map<String, IDocument> documents) throws Exception {
        StringBuilder batchRequestBuilder = new StringBuilder();
        documents.forEach((documentId, document) -> batchRequestBuilder.append(this.createBulkInstruction((String)documentId, (IDocument)document)));
        String response = this.httpRequester.getRestResponse(HttpRequester.RestRequestType.POST, this.url.toString(), batchRequestBuilder.toString(), this.credentials, "application/json");
        ElasticSearchResponse responseJson = (ElasticSearchResponse)GsonUtils.getGson().fromJson(response, ElasticSearchResponse.class);
        if (responseJson.hasErrors()) {
            throw new ServerException(this.getSubmissionErrorText(responseJson));
        }
    }

    private String getSubmissionErrorText(ElasticSearchResponse responseJson) {
        List<ElasticSearchIndexWrapper> submittedItems = responseJson.getItems();
        StringBuilder sb = new StringBuilder();
        int l = submittedItems.size();
        for (int i = 0; i < l; ++i) {
            ElasticSearchIndex indexElement = submittedItems.get(i).getIndex();
            if (indexElement.getError() == null) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(indexElement.getErrorText());
        }
        return sb.toString();
    }

    private String createBulkInstruction(String documentId, IDocument doc) {
        String bulkInstruction;
        if (doc != null) {
            String jsonString = this.toElasticSearchJson(doc);
            bulkInstruction = String.format("{\"index\":{\"_id\":\"%s\"}}%n%s%n", documentId, jsonString);
        } else {
            bulkInstruction = String.format("{\"delete\":{\"_id\":\"%s\"}}%n", documentId);
        }
        return bulkInstruction;
    }

    private String toElasticSearchJson(IDocument document) {
        String jsonString = GsonUtils.getGson().toJson((Object)document, document.getClass());
        return jsonString.replaceAll("\"value\":\"(\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d[^\"]*?Z)?/(\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d[^\"]*?Z)?\"", "\"value\":\\{\"gte\":\"$1\",\"lte\":\"$2\"\\}").replaceAll("\"value\":(\"\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d[^\"/]*Z\")", "\"value\":\\{\"gte\":$1,\"lte\":$1\\}");
    }

    @Override
    protected void onGlobalParameterChanged(GlobalParameterChangedEvent event) {
        super.onGlobalParameterChanged(event);
        if (event.getParameter().getKey().equals("submissionUrl") && this.url != null) {
            String rawPath = this.url.getPath() + '/';
            String[] path = rawPath.substring(1).split("/");
            String bulkSubmitUrl = this.url.toString();
            if (path.length == 0 || !path[path.length - 1].equals("_bulk")) {
                int queryIndex = bulkSubmitUrl.indexOf(63);
                if (queryIndex != -1) {
                    bulkSubmitUrl = bulkSubmitUrl.substring(0, queryIndex);
                }
                if (bulkSubmitUrl.charAt(bulkSubmitUrl.length() - 1) != '/') {
                    bulkSubmitUrl = bulkSubmitUrl + '/';
                }
                bulkSubmitUrl = bulkSubmitUrl + "_bulk";
            }
            try {
                this.url = new URL(bulkSubmitUrl);
            }
            catch (MalformedURLException e) {
                this.url = null;
            }
        }
    }

    @Override
    protected String getCredentials() {
        String newCredentials = super.getCredentials();
        if (newCredentials != null) {
            return "Basic " + newCredentials;
        }
        return null;
    }

    @Override
    protected int getSizeOfDocument(String documentId, IDocument document) {
        return this.createBulkInstruction(documentId, document).getBytes(MainContext.getCharset()).length;
    }
}

