/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.submission;

import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.config.events.GlobalParameterChangedEvent;
import de.gerdiproject.harvest.config.parameters.IntegerParameter;
import de.gerdiproject.harvest.config.parameters.StringParameter;
import de.gerdiproject.harvest.config.parameters.UrlParameter;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.state.events.AbortingFinishedEvent;
import de.gerdiproject.harvest.state.events.AbortingStartedEvent;
import de.gerdiproject.harvest.state.events.StartAbortingEvent;
import de.gerdiproject.harvest.submission.events.DocumentsSubmittedEvent;
import de.gerdiproject.harvest.submission.events.StartSubmissionEvent;
import de.gerdiproject.harvest.submission.events.SubmissionFinishedEvent;
import de.gerdiproject.harvest.submission.events.SubmissionStartedEvent;
import de.gerdiproject.harvest.utils.CancelableFuture;
import de.gerdiproject.harvest.utils.cache.HarvesterCache;
import de.gerdiproject.harvest.utils.cache.HarvesterCacheManager;
import de.gerdiproject.json.datacite.DataCiteJson;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSubmitter {
    private CancelableFuture<Boolean> currentSubmissionProcess;
    private int failedDocumentCount = 0;
    private String userName;
    private String password;
    private boolean canSubmitOutdatedDocs;
    private boolean canSubmitFailedDocs;
    protected final Logger logger;
    protected final Map<String, IDocument> batchMap;
    protected int processedDocumentCount;
    protected boolean isAborting;
    private int currentBatchSize = 0;
    protected int maxBatchSize;
    protected String credentials;
    protected URL url;
    private final Consumer<StartSubmissionEvent> onStartSubmission = e -> {
        this.canSubmitOutdatedDocs = e.canSubmitOutdatedDocuments();
        this.canSubmitFailedDocs = e.isCanSubmitFailedDocuments();
        this.submitAll();
    };
    private final Consumer<StartAbortingEvent> onStartAborting = e -> {
        this.isAborting = true;
        EventSystem.removeListener(StartAbortingEvent.class, this.onStartAborting);
        EventSystem.sendEvent(new AbortingStartedEvent());
    };

    public AbstractSubmitter() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.batchMap = new HashMap<String, IDocument>();
    }

    public void init() {
        EventSystem.addListener(StartSubmissionEvent.class, this.onStartSubmission);
        EventSystem.addListener(GlobalParameterChangedEvent.class, this::onGlobalParameterChanged);
    }

    public void submitAll() {
        int numberOfDocuments;
        this.failedDocumentCount = numberOfDocuments = this.getNumberOfSubmittableChanges();
        this.isAborting = false;
        this.processedDocumentCount = 0;
        this.currentBatchSize = 0;
        this.batchMap.clear();
        EventSystem.sendEvent(new SubmissionStartedEvent(numberOfDocuments));
        boolean canSubmit = this.canStartSubmission();
        if (canSubmit) {
            EventSystem.addListener(StartAbortingEvent.class, this.onStartAborting);
            this.logger.info(String.format("Submitting documents to: %s", this.url.toString()));
            this.currentSubmissionProcess = this.startSubmissionProcess();
            ((CompletableFuture)this.currentSubmissionProcess.thenApply(isSuccessful -> {
                this.onSubmissionFinished();
                return isSuccessful;
            })).exceptionally(throwable -> {
                if (this.isAborting) {
                    this.onSubmissionAborted();
                } else {
                    this.logger.error("Submission interrupted unexpectedly!", throwable);
                    this.onSubmissionFinished();
                }
                return false;
            });
        } else {
            this.onSubmissionFinished();
        }
    }

    protected CancelableFuture<Boolean> startSubmissionProcess() {
        return new CancelableFuture<Boolean>(() -> {
            boolean areAllSubmissionsSuccessful = true;
            List<HarvesterCache> cacheList = HarvesterCacheManager.instance().getHarvesterCaches();
            for (HarvesterCache cache : cacheList) {
                if (this.isAborting) break;
                boolean wasCacheSubmitted = cache.getChangesCache().forEach((documentId, addedDoc) -> {
                    this.addDocument((String)documentId, (DataCiteJson)addedDoc);
                    return !this.isAborting;
                });
                areAllSubmissionsSuccessful &= wasCacheSubmitted;
            }
            if (this.isAborting) {
                this.batchMap.clear();
                this.currentSubmissionProcess.cancel(false);
            } else if (this.batchMap.size() > 0) {
                areAllSubmissionsSuccessful &= this.trySubmitBatch();
                this.batchMap.clear();
            }
            return areAllSubmissionsSuccessful;
        });
    }

    protected void addDocument(String documentId, DataCiteJson document) {
        if (!this.isAborting) {
            int documentSize = this.getSizeOfDocument(documentId, (IDocument)document);
            if (this.currentBatchSize == 0 && documentSize > this.maxBatchSize) {
                this.logger.error(String.format("Cannot submit document %s, because its submission size is %d bytes, which is larger than the maximum permitted size of %d bytes.", documentId, documentSize, this.maxBatchSize));
                ++this.processedDocumentCount;
                EventSystem.sendEvent(new DocumentsSubmittedEvent(false, 1));
                return;
            }
            if (this.currentBatchSize + documentSize > this.maxBatchSize) {
                this.trySubmitBatch();
                this.batchMap.clear();
                this.currentBatchSize = 0;
            }
            this.batchMap.put(documentId, (IDocument)document);
            this.currentBatchSize += documentSize;
        }
    }

    protected abstract int getSizeOfDocument(String var1, IDocument var2);

    protected abstract void submitBatch(Map<String, IDocument> var1) throws Exception;

    protected boolean canStartSubmission() {
        if (this.url == null) {
            this.logger.error("Cannot submit documents: You need to set up a valid submission URL!");
            return false;
        }
        if (this.getNumberOfSubmittableChanges() == 0) {
            this.logger.error("Cannot submit documents: There are no documents to submit!");
            return false;
        }
        if (!this.canSubmitOutdatedDocs && !MainContext.getTimeKeeper().hasUnsubmittedChanges()) {
            this.logger.error("Cannot submit documents: There are no changes since the last submission!\nIf you want to submit anyway, set the 'submitOutdated'-flag in the configuration.");
            return false;
        }
        if (!this.canSubmitFailedDocs && MainContext.getTimeKeeper().isHarvestIncomplete()) {
            this.logger.error("Cannot submit documents: The harvest was not completed successfully!\nIf you want to submit anyway, set the 'submitIncomplete'-flag in the configuration.");
            return false;
        }
        return true;
    }

    protected void onSubmissionFinished() {
        this.currentSubmissionProcess = null;
        EventSystem.removeListener(StartAbortingEvent.class, this.onStartAborting);
        if (this.failedDocumentCount == this.processedDocumentCount || this.processedDocumentCount == 0) {
            this.logger.warn("Submission failed!");
        } else if (this.failedDocumentCount == 0) {
            this.logger.info("Submission done! All documents were submitted!");
        } else {
            this.logger.warn(String.format("Submission done! Failed to submit %d documents!", this.failedDocumentCount));
        }
        EventSystem.sendEvent(new SubmissionFinishedEvent(this.failedDocumentCount == 0 && this.processedDocumentCount > 0));
        if (this.isAborting) {
            this.onSubmissionAborted();
        }
    }

    protected void onSubmissionAborted() {
        this.currentSubmissionProcess = null;
        this.isAborting = false;
        EventSystem.sendEvent(new AbortingFinishedEvent());
    }

    protected boolean trySubmitBatch() {
        boolean isSuccessful;
        int numberOfDocs = this.batchMap.size();
        try {
            this.submitBatch(this.batchMap);
            this.logger.info(String.format(" Submitted documents %d to %d.", this.processedDocumentCount, this.processedDocumentCount + numberOfDocs));
            this.failedDocumentCount -= numberOfDocs;
            isSuccessful = true;
        }
        catch (Exception e) {
            this.logger.error(String.format("Error submitting documents %s to %s.", String.valueOf(this.processedDocumentCount), String.valueOf(this.processedDocumentCount + numberOfDocs)), (Throwable)e);
            isSuccessful = false;
        }
        EventSystem.sendEvent(new DocumentsSubmittedEvent(isSuccessful, numberOfDocs));
        this.processedDocumentCount += numberOfDocs;
        return isSuccessful;
    }

    protected String getCredentials() {
        if (this.userName == null || this.password == null || this.userName.isEmpty()) {
            return null;
        }
        return Base64.getEncoder().encodeToString((this.userName + ":" + this.password).getBytes(MainContext.getCharset()));
    }

    protected int getNumberOfSubmittableChanges() {
        return HarvesterCacheManager.instance().getNumberOfHarvestedDocuments();
    }

    protected void onGlobalParameterChanged(GlobalParameterChangedEvent e) {
        String paramName;
        switch (paramName = e.getParameter().getKey()) {
            case "submissionSize": {
                this.maxBatchSize = (Integer)((IntegerParameter)e.getParameter()).getValue();
                break;
            }
            case "submissionUrl": {
                this.url = (URL)((UrlParameter)e.getParameter()).getValue();
                break;
            }
            case "submissionUserName": {
                this.userName = (String)((StringParameter)e.getParameter()).getValue();
                this.credentials = this.getCredentials();
                break;
            }
            case "submissionPassword": {
                this.password = (String)((StringParameter)e.getParameter()).getValue();
                this.credentials = this.getCredentials();
                break;
            }
        }
    }
}

