/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.state.impl;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.state.AbstractProgressingState;
import de.gerdiproject.harvest.state.constants.StateEventHandlerConstants;
import de.gerdiproject.harvest.submission.events.DocumentsSubmittedEvent;
import de.gerdiproject.harvest.submission.events.SubmissionFinishedEvent;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import de.gerdiproject.harvest.utils.time.HarvestTimeKeeper;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;

public class SubmittingState
extends AbstractProgressingState {
    private final Consumer<DocumentsSubmittedEvent> onDocumentsSubmitted = e -> this.addProgress(e.getNumberOfSubmittedDocuments());

    public SubmittingState(int numberOfDocsToBeSubmitted) {
        super(numberOfDocsToBeSubmitted);
    }

    @Override
    public String getStatusString() {
        HarvestTimeKeeper timeKeeper = MainContext.getTimeKeeper();
        return String.format("Harvest:     %s%nStorage:     %s%nSubmission:  %s", timeKeeper.getHarvestMeasure().toString(), timeKeeper.getSaveMeasure().toString(), super.getStatusString());
    }

    @Override
    public void onStateEnter() {
        super.onStateEnter();
        EventSystem.addListener(DocumentsSubmittedEvent.class, this.onDocumentsSubmitted);
        EventSystem.addListener(SubmissionFinishedEvent.class, StateEventHandlerConstants.ON_SUBMISSION_FINISHED);
    }

    @Override
    public void onStateLeave() {
        super.onStateLeave();
        EventSystem.removeListener(DocumentsSubmittedEvent.class, this.onDocumentsSubmitted);
        EventSystem.removeListener(SubmissionFinishedEvent.class, StateEventHandlerConstants.ON_SUBMISSION_FINISHED);
    }

    @Override
    public Response startHarvest() {
        return ServerResponseFactory.createBusyResponse("Cannot start harvest: Please wait for all documents to be submitted!", this.estimateRemainingSeconds());
    }

    @Override
    public Response submit() {
        return ServerResponseFactory.createBusyResponse("Cannot submit documents: Please wait for all documents to be submitted!", this.estimateRemainingSeconds());
    }

    @Override
    public Response save() {
        return ServerResponseFactory.createBusyResponse("Cannot save documents: Please wait for all documents to be submitted!", this.estimateRemainingSeconds());
    }

    @Override
    public Response isOutdated() {
        return ServerResponseFactory.createBusyResponse("Cannot process request: Please wait for all documents to be submitted!", this.estimateRemainingSeconds());
    }

    @Override
    public String getName() {
        return "submitting";
    }
}

