/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.scheduler.rest;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.scheduler.events.AddSchedulerTaskEvent;
import de.gerdiproject.harvest.scheduler.events.DeleteSchedulerTaskEvent;
import de.gerdiproject.harvest.scheduler.events.GetScheduleEvent;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="schedule")
public class SchedulerFacade {
    @GET
    @Produces(value={"text/plain", "application/json"})
    public String getInfo() {
        String schedule = (String)EventSystem.sendSynchronousEvent(new GetScheduleEvent());
        if (schedule == null) {
            schedule = "Initializing harvester...";
        } else if (schedule.isEmpty()) {
            schedule = "-";
        }
        return String.format("- %s Schedule -%n%nActive Harvesting Schedules:%n%s%n%nPOST?cron=XXX    Adds a new harvest task with the cron tab XXX%nDELETE?cron=XXX  Deletes the harvest task with the cron tab XXX%nDELETE           Deletes all harvest tasks", MainContext.getModuleName(), schedule);
    }

    @POST
    @Produces(value={"text/plain"})
    public Response addTask(@QueryParam(value="cron") String cronTab) {
        return ServerResponseFactory.createSynchronousEventResponse(new AddSchedulerTaskEvent(cronTab));
    }

    @DELETE
    @Produces(value={"text/plain"})
    public Response deleteTask(@QueryParam(value="cron") String cronTab) {
        return ServerResponseFactory.createSynchronousEventResponse(new DeleteSchedulerTaskEvent(cronTab));
    }
}

