/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.harvester.rest;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.harvester.events.GetMaxDocumentCountEvent;
import de.gerdiproject.harvest.state.StateMachine;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import de.gerdiproject.harvest.utils.logger.LoggerUtils;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Path(value="")
public class HarvesterFacade {
    @POST
    @Produces(value={"text/plain"})
    public Response startHarvest(MultivaluedMap<String, String> formParams) {
        return StateMachine.getCurrentState().startHarvest();
    }

    @GET
    @Produces(value={"text/plain", "application/json"})
    public String getInfo() {
        String status = StateMachine.getCurrentState().getStatusString();
        String from = "???";
        String to = "???";
        Configuration config = MainContext.getConfiguration();
        if (config != null) {
            Integer maxDocs;
            from = config.getParameterStringValue("harvestFrom");
            to = config.getParameterStringValue("harvestTo");
            if (to.equals("max") && (maxDocs = (Integer)EventSystem.sendSynchronousEvent(new GetMaxDocumentCountEvent())) != null && maxDocs > 0) {
                try {
                    int maxRange = Integer.parseInt(from) + maxDocs;
                    to = String.format("%d (max)", maxRange);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String name = MainContext.getModuleName();
        return String.format("- %s -%n%n%s%n%nRange:  %s-%s%n%nGET/outdated Checks if there is unharvested metadata%nPOST         Starts the harvest%nPOST/abort   Aborts an ongoing harvest, saving, or submission%nPOST/submit  Submits harvested documents to a DataBase%nPOST/save    Saves harvested documents to disk%nPOST/reset   Attempts to re-initialize this service%n%nGET/config    Displays a table of parameters and a means of%n              configuring them%nGET/status    Additional GET requests for retrieving concrete%n              harvester status values%nGET/schedule  Displays a configurable set of cron jobs that%n              can trigger harvests automatically%nGET/log       Displays the server log. The query parameters%n              'date', 'class', and 'level' can be used to%n              filter the log with comma-separated values of%n              dates, logger classes, and log levels.", name, status, from, to);
    }

    @GET
    @Path(value="outdated")
    @Produces(value={"text/plain", "application/json"})
    public Response isOutdated() {
        return StateMachine.getCurrentState().isOutdated();
    }

    @POST
    @Path(value="abort")
    @Produces(value={"text/plain"})
    public Response abort() {
        return StateMachine.getCurrentState().abort();
    }

    @POST
    @Path(value="save")
    @Produces(value={"text/plain"})
    public Response saveDocuments() {
        return StateMachine.getCurrentState().save();
    }

    @POST
    @Path(value="submit")
    @Produces(value={"text/plain"})
    public Response submitDocuments() {
        return StateMachine.getCurrentState().submit();
    }

    @POST
    @Path(value="reset")
    @Produces(value={"text/plain"})
    public Response reset() {
        return StateMachine.getCurrentState().reset();
    }

    @GET
    @Path(value="log")
    @Produces(value={"text/plain"})
    public Response getLog(@QueryParam(value="date") String dateString, @QueryParam(value="level") String levelString, @QueryParam(value="class") String classString) {
        List<String> classFilters;
        List<String> levelFilters;
        List<String> dateFilters = dateString == null ? null : Arrays.asList(dateString.split(","));
        String log = LoggerUtils.getLog(dateFilters, levelFilters = levelString == null ? null : Arrays.asList(levelString.split(",")), classFilters = classString == null ? null : Arrays.asList(classString.split(",")));
        if (log == null) {
            return ServerResponseFactory.createServerErrorResponse();
        }
        return ServerResponseFactory.createOkResponse(log);
    }
}

