/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.harvester;

import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.harvest.harvester.AbstractHarvester;
import de.gerdiproject.harvest.utils.HashGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;

public abstract class AbstractListHarvester<T>
extends AbstractHarvester {
    protected Collection<T> entries;
    protected final int numberOfDocumentsPerEntry;

    public AbstractListHarvester(String harvesterName, int numberOfDocumentsPerEntry) {
        super(harvesterName);
        this.numberOfDocumentsPerEntry = numberOfDocumentsPerEntry;
    }

    public AbstractListHarvester(int numberOfDocumentsPerEntry) {
        this(null, numberOfDocumentsPerEntry);
    }

    protected abstract Collection<T> loadEntries();

    protected abstract List<IDocument> harvestEntry(T var1);

    @Override
    protected boolean harvestInternal(int from, int to) throws Exception {
        if (from == to) {
            this.logger.warn(String.format("Skipping %s - Document indices out of range.", this.name));
            return true;
        }
        if (this.entries == null || this.entries.isEmpty()) {
            this.logger.error(String.format("Cannot harvest %s - The source entries are empty or could not be retrieved!", this.name));
            return false;
        }
        int firstEntryIndex = from / this.numberOfDocumentsPerEntry;
        int lastEntryIndex = (to - 1) / this.numberOfDocumentsPerEntry;
        int startIndex = from % this.numberOfDocumentsPerEntry;
        int endIndex = to % this.numberOfDocumentsPerEntry;
        if (endIndex == 0) {
            endIndex = this.numberOfDocumentsPerEntry;
        }
        int i = 0;
        for (T e : this.entries) {
            if (this.isAborting) {
                this.currentHarvestingProcess.cancel(false);
                return false;
            }
            if (i >= firstEntryIndex) {
                int jEnd;
                List<IDocument> docs = this.harvestEntry(e);
                int j = i == firstEntryIndex ? startIndex : 0;
                int n = jEnd = i == lastEntryIndex ? endIndex : this.numberOfDocumentsPerEntry;
                if (docs != null) {
                    while (j < jEnd && j < docs.size()) {
                        this.addDocument(docs.get(j++));
                    }
                }
                while (j++ < jEnd) {
                    this.addDocument(null);
                }
                if (i == lastEntryIndex) break;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void init() {
        this.entries = this.loadEntries();
        super.init();
    }

    @Override
    protected int initMaxNumberOfDocuments() {
        return this.entries.size() * this.numberOfDocumentsPerEntry;
    }

    @Override
    protected String initHash() throws NoSuchAlgorithmException, NullPointerException {
        return HashGenerator.instance().getShaHash(this.entries.toString());
    }
}

