/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.event;

import de.gerdiproject.harvest.event.IEvent;
import de.gerdiproject.harvest.event.ISynchronousEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public class EventSystem {
    private final Map<Class<? extends IEvent>, List<Consumer<? extends IEvent>>> callbackMap = new HashMap<Class<? extends IEvent>, List<Consumer<? extends IEvent>>>();
    private final Map<Class<? extends ISynchronousEvent<?>>, Function<? extends ISynchronousEvent<?>, ?>> synchronousCallbackMap = new HashMap();
    private final Queue<IEvent> asyncEventQueue = new ConcurrentLinkedQueue<IEvent>();
    private final AtomicBoolean isProcessingEvents = new AtomicBoolean(false);
    private static final EventSystem instance = new EventSystem();

    private EventSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends IEvent> void addListener(Class<T> eventClass, Consumer<T> callback) {
        Map<Class<? extends IEvent>, List<Consumer<? extends IEvent>>> map = EventSystem.instance.callbackMap;
        synchronized (map) {
            List<Consumer<? extends IEvent>> eventList = EventSystem.instance.callbackMap.get(eventClass);
            if (eventList == null) {
                eventList = new LinkedList<Consumer<? extends IEvent>>();
                EventSystem.instance.callbackMap.put(eventClass, eventList);
            }
            eventList.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends IEvent> void removeListener(Class<T> eventClass, Consumer<T> callback) {
        Map<Class<? extends IEvent>, List<Consumer<? extends IEvent>>> map = EventSystem.instance.callbackMap;
        synchronized (map) {
            List<Consumer<? extends IEvent>> eventList = EventSystem.instance.callbackMap.get(eventClass);
            if (eventList != null) {
                eventList.remove(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends IEvent> void removeAllListeners(Class<T> eventClass) {
        Map<Class<? extends IEvent>, List<Consumer<? extends IEvent>>> map = EventSystem.instance.callbackMap;
        synchronized (map) {
            List<Consumer<? extends IEvent>> eventList = EventSystem.instance.callbackMap.remove(eventClass);
            if (eventList != null) {
                List<Consumer<? extends IEvent>> list = eventList;
                synchronized (list) {
                    eventList.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        EventSystem.instance.asyncEventQueue.clear();
        EventSystem.instance.synchronousCallbackMap.clear();
        Map<Class<? extends IEvent>, List<Consumer<? extends IEvent>>> map = EventSystem.instance.callbackMap;
        synchronized (map) {
            Collection<List<Consumer<? extends IEvent>>> listenerLists = EventSystem.instance.callbackMap.values();
            for (List<Consumer<? extends IEvent>> listeners : listenerLists) {
                listeners.clear();
            }
            EventSystem.instance.callbackMap.clear();
        }
    }

    public static <T extends IEvent> void sendEvent(T event) {
        EventSystem.instance.asyncEventQueue.add(event);
        instance.processAsynchronousEventQueue();
    }

    private void processAsynchronousEventQueue() {
        if (!this.isProcessingEvents.get()) {
            this.isProcessingEvents.set(true);
            while (!this.asyncEventQueue.isEmpty()) {
                this.executeAsynchronousCallbacks(this.asyncEventQueue.poll());
            }
            this.isProcessingEvents.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IEvent> void executeAsynchronousCallbacks(T event) {
        List<Consumer<? extends IEvent>> eventList;
        Object object = this.callbackMap;
        synchronized (object) {
            eventList = this.callbackMap.get(event.getClass());
        }
        if (eventList != null) {
            object = eventList;
            synchronized (object) {
                int i = eventList.size();
                while (i != 0) {
                    eventList.get(--i).accept(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, T extends ISynchronousEvent<R>> void addSynchronousListener(Class<T> eventClass, Function<T, R> callback) {
        Map<Class<? extends ISynchronousEvent<?>>, Function<? extends ISynchronousEvent<?>, ?>> map = EventSystem.instance.synchronousCallbackMap;
        synchronized (map) {
            EventSystem.instance.synchronousCallbackMap.put(eventClass, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ISynchronousEvent<?>> void removeSynchronousListener(Class<T> eventClass) {
        Map<Class<? extends ISynchronousEvent<?>>, Function<? extends ISynchronousEvent<?>, ?>> map = EventSystem.instance.synchronousCallbackMap;
        synchronized (map) {
            EventSystem.instance.synchronousCallbackMap.remove(eventClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, T extends ISynchronousEvent<R>> R sendSynchronousEvent(T event) {
        Map<Class<? extends ISynchronousEvent<?>>, Function<? extends ISynchronousEvent<?>, ?>> map = EventSystem.instance.synchronousCallbackMap;
        synchronized (map) {
            Function<ISynchronousEvent<?>, ?> callback = EventSystem.instance.synchronousCallbackMap.get(event.getClass());
            if (callback != null) {
                return (R)callback.apply(event);
            }
            return null;
        }
    }
}

