/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.rest;

import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.config.Configuration;
import de.gerdiproject.harvest.utils.ServerResponseFactory;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Path(value="config")
public final class ConfigurationFacade {
    @GET
    @Produces(value={"text/plain"})
    public Response getValue(@QueryParam(value="key") String key) {
        Configuration config = MainContext.getConfiguration();
        if (config == null) {
            return ServerResponseFactory.createServerErrorResponse();
        }
        String entity = key == null ? config.getInfoString() : config.getParameterStringValue(key);
        return ServerResponseFactory.createOkResponse(entity);
    }

    @POST
    @Produces(value={"text/plain"})
    public Response saveToDisk() {
        Configuration config = MainContext.getConfiguration();
        if (config == null) {
            return ServerResponseFactory.createServerErrorResponse();
        }
        return ServerResponseFactory.createOkResponse(config.saveToDisk());
    }

    @PUT
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response setParameters(MultivaluedMap<String, String> formParams) {
        Configuration config = MainContext.getConfiguration();
        if (config == null) {
            return ServerResponseFactory.createServerErrorResponse();
        }
        StringBuilder sb = new StringBuilder();
        if (formParams != null) {
            for (Map.Entry entry : formParams.entrySet()) {
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                values.forEach(value -> sb.append(config.setParameter(key, (String)value)).append('\n'));
            }
        }
        if (sb.length() == 0) {
            return ServerResponseFactory.createBadRequestResponse("No parameters were changed!");
        }
        return ServerResponseFactory.createOkResponse(sb.toString());
    }
}

