/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.parameters;

import de.gerdiproject.harvest.config.constants.ConfigurationConstants;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.state.IState;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.List;

public class UrlParameter
extends AbstractParameter<URL> {
    public UrlParameter(String key, List<Class<? extends IState>> allowedStates, URL defaultValue) {
        super(key, allowedStates, "<a valid URL>");
        this.value = defaultValue;
    }

    public UrlParameter(String key, String defaultUrlString) {
        super(key, ConfigurationConstants.HARVESTER_PARAM_ALLOWED_STATES, "<a valid URL>");
        this.setValue(defaultUrlString, null);
    }

    @Override
    public URL stringToValue(String value) throws ParseException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value.startsWith("%URL_PARAMETER%")) {
            value = value.substring("%URL_PARAMETER%".length());
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new ParseException(String.format("Cannot change parameter '%s'. '%s' is not a valid URL!", this.key, value), 0);
        }
    }
}

