/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.config.parameters;

import de.gerdiproject.harvest.config.constants.ConfigurationConstants;
import de.gerdiproject.harvest.config.parameters.AbstractParameter;
import de.gerdiproject.harvest.config.parameters.BooleanParameter;
import de.gerdiproject.harvest.config.parameters.IntegerParameter;
import de.gerdiproject.harvest.config.parameters.PasswordParameter;
import de.gerdiproject.harvest.config.parameters.StringParameter;
import de.gerdiproject.harvest.config.parameters.UrlParameter;
import de.gerdiproject.harvest.state.IState;
import de.gerdiproject.harvest.state.impl.ErrorState;
import de.gerdiproject.harvest.state.impl.HarvestingState;
import de.gerdiproject.harvest.state.impl.IdleState;
import de.gerdiproject.harvest.state.impl.InitializationState;
import de.gerdiproject.harvest.state.impl.SavingState;
import de.gerdiproject.harvest.state.impl.SubmittingState;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ParameterFactory {
    public static Map<String, AbstractParameter<?>> createDefaultParameters() {
        LinkedHashMap params = new LinkedHashMap();
        BooleanParameter autoSave = ParameterFactory.createAutoSave();
        BooleanParameter autoSubmit = ParameterFactory.createAutoSubmit();
        BooleanParameter readFromDisk = ParameterFactory.createReadFromDisk();
        BooleanParameter writeToDisk = ParameterFactory.createWriteToDisk();
        UrlParameter submitUrl = ParameterFactory.createSubmissionUrl();
        IntegerParameter submitSize = ParameterFactory.createSubmissionSize();
        StringParameter submitName = ParameterFactory.createSubmissionUserName();
        PasswordParameter submitPassword = ParameterFactory.createSubmissionPassword();
        AbstractParameter<?> deleteUnfinishedSaves = ParameterFactory.createDeleteUnfinishedSaves();
        BooleanParameter submitIncompleteHarvests = ParameterFactory.createSubmitIncomplete();
        BooleanParameter submitOutdated = ParameterFactory.createSubmitOutdated();
        AbstractParameter<?> persistCache = ParameterFactory.createPersistCache();
        params.put(autoSave.getKey(), autoSave);
        params.put(autoSubmit.getKey(), autoSubmit);
        params.put(submitUrl.getKey(), submitUrl);
        params.put(submitName.getKey(), submitName);
        params.put(submitPassword.getKey(), submitPassword);
        params.put(submitSize.getKey(), submitSize);
        params.put(submitIncompleteHarvests.getKey(), submitIncompleteHarvests);
        params.put(submitOutdated.getKey(), submitOutdated);
        params.put(readFromDisk.getKey(), readFromDisk);
        params.put(writeToDisk.getKey(), writeToDisk);
        params.put(deleteUnfinishedSaves.getKey(), deleteUnfinishedSaves);
        params.put(persistCache.getKey(), persistCache);
        return params;
    }

    public static Map<String, AbstractParameter<?>> createHarvesterParameters(List<AbstractParameter<?>> harvesterParams) {
        LinkedHashMap params = new LinkedHashMap();
        IntegerParameter harvestStartIndex = ParameterFactory.createHarvestStartIndex();
        IntegerParameter harvestEndIndex = ParameterFactory.createHarvestEndIndex();
        AbstractParameter<?> forceHarvest = ParameterFactory.createForceHarvest();
        params.put(harvestStartIndex.getKey(), harvestStartIndex);
        params.put(harvestEndIndex.getKey(), harvestEndIndex);
        params.put(forceHarvest.getKey(), forceHarvest);
        if (harvesterParams != null) {
            for (AbstractParameter<?> hParam : harvesterParams) {
                params.put(hParam.getKey(), hParam);
            }
        }
        return params;
    }

    public static BooleanParameter createAutoSave() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(InitializationState.class, ErrorState.class, IdleState.class, HarvestingState.class, SavingState.class, SubmittingState.class);
        return new BooleanParameter("autoSave", allowedStates, true);
    }

    public static BooleanParameter createAutoSubmit() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(InitializationState.class, ErrorState.class, IdleState.class, HarvestingState.class, SavingState.class, SubmittingState.class);
        return new BooleanParameter("autoSubmit", allowedStates, false);
    }

    public static BooleanParameter createWriteToDisk() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(ErrorState.class, IdleState.class, SavingState.class, SubmittingState.class);
        return new BooleanParameter("writeToDisk", allowedStates, false);
    }

    public static BooleanParameter createReadFromDisk() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(ErrorState.class, IdleState.class, SavingState.class, SubmittingState.class);
        return new BooleanParameter("readFromDisk", allowedStates, false);
    }

    public static AbstractParameter<?> createForceHarvest() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(InitializationState.class, ErrorState.class, IdleState.class, SavingState.class, SubmittingState.class);
        return new BooleanParameter("forceHarvest", allowedStates, false);
    }

    public static AbstractParameter<?> createDeleteUnfinishedSaves() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(InitializationState.class, ErrorState.class, IdleState.class, HarvestingState.class, SubmittingState.class);
        return new BooleanParameter("deleteFailedSaves", allowedStates, true);
    }

    public static UrlParameter createSubmissionUrl() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(InitializationState.class, ErrorState.class, IdleState.class, HarvestingState.class, SavingState.class);
        return new UrlParameter("submissionUrl", allowedStates, null);
    }

    public static StringParameter createSubmissionUserName() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(InitializationState.class, ErrorState.class, IdleState.class, HarvestingState.class, SavingState.class);
        return new StringParameter("submissionUserName", allowedStates, null);
    }

    public static PasswordParameter createSubmissionPassword() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(InitializationState.class, ErrorState.class, IdleState.class, HarvestingState.class, SavingState.class);
        return new PasswordParameter("submissionPassword", allowedStates);
    }

    public static IntegerParameter createSubmissionSize() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(InitializationState.class, ErrorState.class, IdleState.class, HarvestingState.class, SavingState.class);
        return new IntegerParameter("submissionSize", allowedStates, 0x100000);
    }

    private static BooleanParameter createSubmitOutdated() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(InitializationState.class, ErrorState.class, IdleState.class, HarvestingState.class, SavingState.class);
        return new BooleanParameter("submitOutdated", allowedStates, false);
    }

    private static BooleanParameter createSubmitIncomplete() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(InitializationState.class, ErrorState.class, IdleState.class, HarvestingState.class, SavingState.class);
        return new BooleanParameter("submitIncomplete", allowedStates, false);
    }

    private static AbstractParameter<?> createPersistCache() {
        List<Class<? extends IState>> allowedStates = Arrays.asList(ErrorState.class, IdleState.class, SubmittingState.class, SavingState.class);
        return new BooleanParameter("persistCache", allowedStates, true);
    }

    public static IntegerParameter createHarvestStartIndex() {
        return new IntegerParameter("harvestFrom", ConfigurationConstants.HARVESTER_PARAM_ALLOWED_STATES, 0);
    }

    public static IntegerParameter createHarvestEndIndex() {
        return new IntegerParameter("harvestTo", ConfigurationConstants.HARVESTER_PARAM_ALLOWED_STATES, Integer.MAX_VALUE);
    }

    private ParameterFactory() {
    }
}

