/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.time;

import de.gerdiproject.harvest.event.AbstractSucceededOrFailedEvent;
import de.gerdiproject.harvest.event.EventSystem;
import de.gerdiproject.harvest.event.IEvent;
import de.gerdiproject.harvest.state.events.AbortingStartedEvent;
import de.gerdiproject.harvest.utils.time.events.ProcessTimeMeasureFinishedEvent;
import java.util.Date;
import java.util.function.Consumer;

public class ProcessTimeMeasure {
    private long startTimestamp = -1L;
    private long endTimestamp = -1L;
    private ProcessStatus status = ProcessStatus.NotStarted;
    private transient ProcessTimeMeasureFinishedEvent finishedEvent;

    public <R extends IEvent, T extends AbstractSucceededOrFailedEvent> void init(Class<R> startEvent, Class<T> endEvent) {
        Consumer<IEvent> onProcessStarted = event -> this.start();
        Consumer<AbstractSucceededOrFailedEvent> onProcessFinished = event -> {
            if (event.isSuccessful()) {
                this.end(ProcessStatus.Finished);
            } else {
                this.end(ProcessStatus.Failed);
            }
        };
        Consumer<AbortingStartedEvent> onProcessAborted = event -> this.end(ProcessStatus.Aborted);
        this.finishedEvent = new ProcessTimeMeasureFinishedEvent(this);
        EventSystem.addListener(startEvent, onProcessStarted);
        EventSystem.addListener(endEvent, onProcessFinished);
        EventSystem.addListener(AbortingStartedEvent.class, onProcessAborted);
    }

    private void start() {
        this.startTimestamp = System.currentTimeMillis();
        this.endTimestamp = -1L;
        this.status = ProcessStatus.Started;
    }

    private void end(ProcessStatus reasonToEnd) {
        if (this.status == ProcessStatus.Started) {
            this.endTimestamp = System.currentTimeMillis();
            this.status = reasonToEnd;
            EventSystem.sendEvent(this.finishedEvent);
        }
    }

    public void set(ProcessTimeMeasure other) {
        if (this.status != ProcessStatus.Started) {
            this.status = other.status;
            this.startTimestamp = other.startTimestamp;
            this.endTimestamp = other.endTimestamp;
        }
    }

    public void set(long startTimestamp, long endTimestamp, ProcessStatus status) {
        if (this.status != ProcessStatus.Started) {
            this.status = status;
            this.startTimestamp = startTimestamp;
            this.endTimestamp = endTimestamp;
        }
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    public String toString() {
        if (this.endTimestamp != -1L) {
            return String.format("%s at %s", this.status.name(), new Date(this.endTimestamp).toString());
        }
        if (this.startTimestamp != -1L) {
            return String.format("%s at %s", this.status.name(), new Date(this.startTimestamp).toString());
        }
        return this.status.name();
    }

    public static enum ProcessStatus {
        NotStarted,
        Started,
        Finished,
        Aborted,
        Failed;

    }
}

