/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.maven;

import de.gerdiproject.harvest.ContextListener;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class MavenUtils {
    private static final MavenUtils instance = new MavenUtils();
    private String harvesterJarName;

    private MavenUtils() {
    }

    public void init(ContextListener<?> context) {
        Class<?> contextListenerClass = context.getClass();
        String resourcePath = contextListenerClass.getResource(contextListenerClass.getSimpleName() + ".class").toString();
        this.harvesterJarName = resourcePath.replaceAll("^.+/([^/]*?)\\.jar!.+$", "$1");
    }

    public static MavenUtils instance() {
        return instance;
    }

    public List<String> getMavenVersionInfo(String groupId) {
        LinkedList<String> dependencyList = new LinkedList<String>();
        String projectFilter = String.format("META-INF/maven/%s", groupId == null ? "" : groupId);
        try {
            Enumeration<URL> gerdiMavenLibraries = MavenUtils.class.getClassLoader().getResources(projectFilter);
            while (gerdiMavenLibraries.hasMoreElements()) {
                String resourcePath = gerdiMavenLibraries.nextElement().toString();
                if (!resourcePath.startsWith("jar:")) continue;
                dependencyList.add(resourcePath.replaceAll("^.+/([^/]*?)\\.jar!.+$", "$1"));
            }
        }
        catch (IOException e) {
            return null;
        }
        Collections.sort(dependencyList, String.CASE_INSENSITIVE_ORDER);
        return dependencyList;
    }

    public String getHarvesterJarName() {
        return this.harvesterJarName;
    }
}

