/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.utils.data.IDataRetriever;
import de.gerdiproject.json.GsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDataRetriever
implements IDataRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDataRetriever.class);

    @Override
    public String getString(String url) {
        String responseText = null;
        try (BufferedReader reader = new BufferedReader(this.createWebReader(url));){
            String line = reader.readLine();
            if (line != null) {
                StringBuilder responseBuilder = new StringBuilder(line);
                line = reader.readLine();
                while (line != null) {
                    responseBuilder.append('\n').append(line);
                    line = reader.readLine();
                }
                responseText = responseBuilder.toString();
            }
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Could not load and parse from web: %s", url), (Throwable)e);
        }
        return responseText;
    }

    @Override
    public JsonElement getJson(String url) {
        JsonElement jsonResponse = null;
        try (InputStreamReader reader = this.createWebReader(url);){
            JsonParser parser = new JsonParser();
            jsonResponse = parser.parse((Reader)reader);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Could not load and parse from web: %s", url), (Throwable)e);
        }
        return jsonResponse;
    }

    @Override
    public <T> T getObject(String url, Class<T> targetClass) {
        Object object = null;
        try (InputStreamReader reader = this.createWebReader(url);){
            object = GsonUtils.getGson().fromJson((Reader)reader, targetClass);
        }
        catch (JsonIOException | JsonSyntaxException | IOException | IllegalStateException e) {
            LOGGER.warn(String.format("Could not load and parse from web: %s", url), e);
        }
        return (T)object;
    }

    @Override
    public <T> T getObject(String url, Type targetType) {
        Object object = null;
        try (InputStreamReader reader = this.createWebReader(url);){
            object = GsonUtils.getGson().fromJson((Reader)reader, targetType);
        }
        catch (JsonIOException | JsonSyntaxException | IOException | IllegalStateException e) {
            LOGGER.warn(String.format("Could not load and parse from web: %s", url), e);
        }
        return (T)object;
    }

    @Override
    public Document getHtml(String url) {
        Document htmlResponse = null;
        try (InputStream response = new URL(url).openStream();){
            htmlResponse = Jsoup.parse((InputStream)response, (String)MainContext.getCharset().displayName(), (String)url);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Could not load and parse from web: %s", url), (Throwable)e);
        }
        return htmlResponse;
    }

    private InputStreamReader createWebReader(String url) throws MalformedURLException, IOException {
        return new InputStreamReader(new URL(url).openStream(), MainContext.getCharset());
    }
}

