/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import de.gerdiproject.harvest.MainContext;
import de.gerdiproject.harvest.utils.data.IDataRetriever;
import de.gerdiproject.json.GsonUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskIO
implements IDataRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskIO.class);

    public String writeStringToFile(String filePath, String fileContent) {
        return this.writeStringToFile(new File(filePath), fileContent);
    }

    public String writeStringToFile(File file, String fileContent) {
        String statusMessage;
        boolean isDirectoryCreated;
        String filePath = file.getAbsolutePath();
        boolean isSuccessful = false;
        boolean bl = isDirectoryCreated = file.getParentFile().exists() || file.getParentFile().mkdirs();
        if (!isDirectoryCreated) {
            statusMessage = String.format("Could not write to file '%s': Failed to create directories!", filePath);
        } else {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                writer.write(fileContent);
                isSuccessful = true;
                statusMessage = String.format("Saved file: %s", filePath);
            }
            catch (IOException | SecurityException e) {
                LOGGER.warn(String.format("Could not write to file: %s", filePath), (Throwable)e);
                statusMessage = String.format("Could not write to file: %s", filePath);
            }
        }
        if (isSuccessful) {
            LOGGER.trace(statusMessage);
        } else {
            LOGGER.warn(statusMessage);
        }
        return statusMessage;
    }

    public String writeObjectToFile(String filePath, Object obj) {
        String jsonString = obj == null ? "{}" : GsonUtils.getGson().toJson(obj);
        return this.writeStringToFile(filePath, jsonString);
    }

    public String writeObjectToFile(File file, Object obj) {
        String jsonString = obj == null ? "{}" : GsonUtils.getGson().toJson(obj);
        return this.writeStringToFile(file, jsonString);
    }

    public String getString(File file) {
        String fileContent = null;
        try (BufferedReader reader2 = new BufferedReader(this.createDiskReader(file));){
            fileContent = reader2.lines().collect(Collectors.joining("\n"));
        }
        catch (FileNotFoundException reader2) {
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Could not load file: %s", file.getAbsolutePath()), (Throwable)e);
        }
        return fileContent;
    }

    public <T> T getObject(File file, Class<T> targetClass) {
        Object object = null;
        try (Reader reader2 = this.createDiskReader(file);){
            object = GsonUtils.getGson().fromJson(reader2, targetClass);
        }
        catch (FileNotFoundException reader2) {
        }
        catch (JsonIOException | JsonSyntaxException | IOException | IllegalStateException e) {
            LOGGER.warn(String.format("Could not load file: %s", file.getAbsolutePath()), e);
        }
        return (T)object;
    }

    public <T> T getObject(File file, Type targetType) {
        Object object = null;
        try (Reader reader2 = this.createDiskReader(file);){
            object = GsonUtils.getGson().fromJson(reader2, targetType);
        }
        catch (FileNotFoundException reader2) {
        }
        catch (JsonIOException | JsonSyntaxException | IOException | IllegalStateException e) {
            LOGGER.warn(String.format("Could not load file: %s", file.getAbsolutePath()), e);
        }
        return (T)object;
    }

    @Override
    public String getString(String filePath) {
        return this.getString(new File(filePath));
    }

    @Override
    public JsonElement getJson(String filePath) {
        return this.getObject(new File(filePath), JsonElement.class);
    }

    @Override
    public <T> T getObject(String filePath, Class<T> targetClass) {
        return this.getObject(new File(filePath), targetClass);
    }

    @Override
    public <T> T getObject(String filePath, Type targetType) {
        return this.getObject(new File(filePath), targetType);
    }

    @Override
    public Document getHtml(String filePath) {
        Document htmlResponse = null;
        String fileContent = this.getString(filePath);
        if (fileContent != null) {
            htmlResponse = Jsoup.parse((String)fileContent);
        }
        return htmlResponse;
    }

    private Reader createDiskReader(File file) throws FileNotFoundException {
        return new InputStreamReader((InputStream)new FileInputStream(file), MainContext.getCharset());
    }
}

